/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class BibleCanvas
extends Canvas
implements CommandListener {
    private static final boolean DEBUG = false;
    private static final int TEXT_BORDER_LEFT = 3;
    private static final int TEXT_BORDER_RIGHT = 3;
    private static final int BAR_PADDING = 2;
    private static final int BOX_CORNER = 10;
    private static final int MODE_SPLASH = 0;
    private static final int MODE_LOADING = 1;
    private static final int MODE_VIEWING = 2;
    private static final int MODE_GOTO = 3;
    private static final int SELECTION_BOOK = 0;
    private static final int SELECTION_CHAPTER = 1;
    private static final int SELECTION_VERSE = 2;
    private static final int SELECTION_BORDER = 5;
    private static final int ALIGN_LEFT = 0;
    private static final int ALIGN_RIGHT = 1;
    private static final char STYLE_RED = '~';
    private static final char NEXT_LINE = '^';
    private static final char CHANGE_COLOUR = '\u0001';
    private static final int COLOUR_RED = 0xB00000;
    private static final int HIGHLIGHT_BACKGROUND_COLOUR = 0xE0E0FF;
    private static final int HIGHLIGHT_OUTLINE_COLOUR = 0xC0C0FF;
    private BiblePhone biblePhone;
    private Command multilingualCommand = new Command(BiblePhone.getString("UI-Multilingual"), 1, 0);
    private Command gotoCommand = new Command(BiblePhone.getString("UI-Goto"), 4, 0);
    private Command searchCommand = new Command(BiblePhone.getString("UI-Search"), 1, 0);
    private Command searchResultsCommand = new Command(BiblePhone.getString("UI-Search-Results"), 1, 0);
    private Command addBookmarkCommand = new Command(BiblePhone.getString("UI-Add-Bookmark"), 1, 0);
    private Command bookmarksCommand = new Command(BiblePhone.getString("UI-Bookmarks"), 1, 0);
    private Command historyCommand = new Command(BiblePhone.getString("UI-History"), 1, 0);
    private Command sendSMSCommand;
    private Command sendMMSCommand;
    private Command prefsCommand = new Command(BiblePhone.getString("UI-Preferences"), 1, 0);
    private Command aboutCommand = new Command(BiblePhone.getString("UI-About"), 1, 0);
    private Command exitCommand = new Command(BiblePhone.getString("UI-Exit"), 7, 0);
    private Command cancelCommand = new Command(BiblePhone.getString("UI-Cancel"), 3, 0);
    private int mode = 0;
    int textColour = 0;
    int backColour = 0xFFFFFF;
    int christWordsColour = 0xFF0000;
    int highlightColour = 0xE0E0FF;
    int align;
    int anchor;
    static boolean reverseCharacters;
    int width;
    int height;
    int lineStart;
    int lastSpace;
    int y;
    int drawX;
    private boolean moreVerseDown;
    private int[] scrollPoints = new int[100];
    private boolean[] scrollStyleRed = new boolean[100];
    private int currentScrollPointIndex = -1;
    private int currentScrollPoint = -1;
    private boolean currentScrollStyle;
    private int nextScrollPointVerse = -1;
    private int nextScrollPoint;
    private boolean nextScrollStyle;
    private int[] selection = new int[3];
    private int selectionIndex = 0;
    private boolean editingSelection;
    private Image fontImage;
    int xPointer = 0;
    int yPointer = 0;
    int heightGraphicalButtons;
    int lineWidth;
    int numberOfButtons = 5;

    public BibleCanvas(BiblePhone biblePhone) {
        this.biblePhone = biblePhone;
    }

    public void alignment() {
        String alignmentString = BiblePhone.getStringConfig("align" + BiblePhone.BasicModuleIndex, BiblePhone.ConfigIni);
        if (alignmentString == null || alignmentString.equals("left")) {
            this.align = 0;
            this.anchor = 20;
        } else if (alignmentString.equals("right")) {
            this.align = 1;
            this.anchor = 24;
        }
    }

    public void init() {
        this.heightGraphicalButtons = this.biblePhone.heightGraphicalButtons;
        this.lineWidth = this.heightGraphicalButtons / 10;
        this.alignment();
        if (BiblePhone.USE_MIDP20) {
            try {
                Class.forName("javax.wireless.messaging.MessageConnection");
                this.sendSMSCommand = new Command(BiblePhone.getString("UI-Send-SMS"), 1, 0);
                Class.forName("javax.wireless.messaging.MessagePart");
                this.sendMMSCommand = new Command(BiblePhone.getString("UI-Send-MMS"), 1, 0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!this.biblePhone.fullScreen) {
            this.addCommand(this.gotoCommand);
        }
        this.addCommands();
    }

    public void addCommands() {
        if (this.biblePhone.fullScreen) {
            this.addCommand(this.gotoCommand);
        }
        this.addCommand(this.searchCommand);
        this.addCommand(this.searchResultsCommand);
        this.addCommand(this.addBookmarkCommand);
        this.addCommand(this.bookmarksCommand);
        this.addCommand(this.historyCommand);
        if (BiblePhone.USE_MIDP20) {
            if (this.sendSMSCommand != null) {
                this.addCommand(this.sendSMSCommand);
            }
            if (this.sendMMSCommand != null) {
                this.addCommand(this.sendMMSCommand);
            }
        }
        this.addCommand(this.prefsCommand);
        if (BiblePhone.numberOfBibles > 1) {
            String valoare = new String("set");
            this.addCommand(this.multilingualCommand);
            String string = new String("get");
        }
        this.addCommand(this.aboutCommand);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
    }

    public void showNotify() {
    }

    public void commandAction(Command command, Displayable display) {
        switch (command.getCommandType()) {
            case 7: {
                this.biblePhone.destroyApp(false);
                this.biblePhone.notifyDestroyed();
                break;
            }
            case 4: {
                if (command == this.gotoCommand) {
                    this.enterGotoMode();
                }
            }
            case 1: {
                if (command == this.prefsCommand) {
                    this.biblePhone.showPrefsScreen();
                    break;
                }
                if (command == this.aboutCommand) {
                    this.biblePhone.showAboutAlert();
                    break;
                }
                if (command == this.historyCommand) {
                    this.biblePhone.showHistoryScreen();
                    break;
                }
                if (BiblePhone.USE_MIDP20 && command == this.sendSMSCommand) {
                    this.biblePhone.showSendSMSScreen();
                    break;
                }
                if (BiblePhone.USE_MIDP20 && command == this.sendMMSCommand) {
                    this.biblePhone.showSendMMSScreen();
                    break;
                }
                if (command == this.searchCommand) {
                    this.biblePhone.showSearchScreen();
                    break;
                }
                if (command == this.searchResultsCommand) {
                    this.biblePhone.showSearchResultsScreen();
                    break;
                }
                if (command == this.addBookmarkCommand) {
                    this.biblePhone.addBookmark();
                    break;
                }
                if (command == this.bookmarksCommand) {
                    this.biblePhone.showBookmarksScreen();
                    break;
                }
                if (command != this.multilingualCommand) break;
                this.biblePhone.showMultilingualScreen();
                break;
            }
            case 2: 
            case 3: {
                if (this.mode == 3) {
                    this.removeCommand(this.cancelCommand);
                    this.addCommands();
                } else if (this.mode == 2) {
                    this.biblePhone.destroyApp(false);
                    this.biblePhone.notifyDestroyed();
                }
                this.mode = 2;
                this.repaint();
                this.serviceRepaints();
            }
        }
    }

    public void keyPressed(int keyCode) {
        boolean keyHandled = false;
        if (this.mode == 2) {
            switch (keyCode) {
                case 50: {
                    this.biblePhone.previousChapter(false);
                    keyHandled = true;
                    break;
                }
                case 53: {
                    this.biblePhone.nextChapter();
                    keyHandled = true;
                    break;
                }
                case 49: {
                    this.biblePhone.previousBook(true);
                    keyHandled = true;
                    break;
                }
                case 52: {
                    this.biblePhone.nextBook(true);
                    keyHandled = true;
                }
            }
            if (keyHandled) {
                this.update();
            } else {
                int gameAction = this.getGameAction(keyCode);
                if (gameAction == 1 || keyCode == 51) {
                    if (this.currentScrollPointIndex > 0) {
                        --this.currentScrollPointIndex;
                        this.repaint();
                        this.serviceRepaints();
                    } else if (this.currentScrollPoint >= 0) {
                        this.update();
                    } else {
                        this.biblePhone.scrollPrevious();
                        this.update();
                    }
                } else if (gameAction == 6 || keyCode == 54) {
                    if (this.moreVerseDown) {
                        ++this.currentScrollPointIndex;
                        this.repaint();
                        this.serviceRepaints();
                    } else if (this.nextScrollPointVerse >= 0) {
                        this.biblePhone.currentVerseIndex = this.nextScrollPointVerse;
                        this.currentScrollPoint = this.nextScrollPoint;
                        this.currentScrollStyle = this.nextScrollStyle;
                        this.currentScrollPointIndex = -1;
                        this.repaint();
                        this.serviceRepaints();
                    } else {
                        this.biblePhone.nextChapter();
                        this.update();
                    }
                } else if (gameAction == 8) {
                    this.enterGotoMode();
                }
            }
        } else if (this.mode == 3) {
            int startIndex = 1;
            if (this.selectionIndex == 1) {
                startIndex = this.biblePhone.getStartChapter(this.selection[0]);
            }
            if (this.selectionIndex >= 1 && keyCode >= 48 && keyCode <= 57) {
                int value = keyCode - 48;
                int index = this.selection[this.selectionIndex];
                if (!this.editingSelection) {
                    if (keyCode != 48) {
                        this.editingSelection = true;
                        this.selection[this.selectionIndex] = value - startIndex;
                    }
                } else if (index + startIndex < 100) {
                    this.selection[this.selectionIndex] = (index + startIndex) * 10 + value - startIndex;
                }
            } else {
                this.editingSelection = false;
                int gameAction = this.getGameAction(keyCode);
                if (keyCode == 42) {
                    gameAction = 2;
                } else if (keyCode == 35) {
                    gameAction = 5;
                }
                if (gameAction == 0) {
                    if (keyCode == -6) {
                        gameAction = 9;
                    } else if (keyCode == -7) {
                        gameAction = 10;
                    }
                }
                switch (gameAction) {
                    case 2: {
                        --this.selectionIndex;
                        if (this.selectionIndex >= 0) break;
                        this.selectionIndex = 2;
                        break;
                    }
                    case 5: {
                        ++this.selectionIndex;
                        this.selectionIndex %= 3;
                        break;
                    }
                    case 1: {
                        int n = this.selectionIndex;
                        this.selection[n] = this.selection[n] - 1;
                        break;
                    }
                    case 6: {
                        int n = this.selectionIndex;
                        this.selection[n] = this.selection[n] + 1;
                        break;
                    }
                    case 8: {
                        this.enterGotoMode();
                        break;
                    }
                    case 10: {
                        this.addCommands();
                        this.mode = 2;
                        this.repaint();
                        this.serviceRepaints();
                    }
                }
                this.validateSelection();
            }
            this.repaint();
            this.serviceRepaints();
        }
    }

    private boolean validateSelection() {
        boolean correct = true;
        int numberOfBooks = this.biblePhone.getNumberOfBooks();
        if (this.selection[0] >= numberOfBooks) {
            this.selection[0] = 0;
            correct = false;
        } else if (this.selection[0] < 0) {
            this.selection[0] = numberOfBooks - 1;
            correct = false;
        }
        int selectionBook = Integer.parseInt(BiblePhone.ModuleBooks.get(BiblePhone.BooksAvailable.elementAt(this.selection[0])).toString());
        int numberOfChapters = BiblePhone.numberOfVerses[selectionBook].size();
        if (this.selection[1] >= numberOfChapters) {
            this.selection[1] = 0;
            correct = false;
        } else if (this.selection[1] < 0) {
            this.selection[1] = numberOfChapters - 1;
            correct = false;
        }
        int numberOfVerses = Integer.parseInt(BiblePhone.numberOfVerses[selectionBook].elementAt(this.selection[1] + Integer.parseInt(BiblePhone.ChapterStart.elementAt(this.biblePhone.currentBookIndex).toString()) - 1).toString());
        if (this.selection[2] >= numberOfVerses) {
            this.selection[2] = 0;
            correct = false;
        } else if (this.selection[2] < 0) {
            this.selection[2] = numberOfVerses - 1;
            correct = false;
        }
        return correct;
    }

    public void enterLoadingMode() {
        this.mode = 1;
        this.repaint();
        this.serviceRepaints();
    }

    public void update() {
        if (this.mode == 3) {
            // empty if block
        }
        this.removeCommand(this.cancelCommand);
        this.addCommands();
        this.mode = 2;
        this.moreVerseDown = false;
        this.currentScrollPointIndex = -1;
        this.currentScrollPoint = -1;
        this.currentScrollStyle = false;
        this.repaint();
        this.serviceRepaints();
    }

    public void enterGotoMode() {
        if (this.mode == 2) {
            this.mode = 3;
            this.selection[0] = this.biblePhone.currentBookIndex;
            this.selection[1] = this.biblePhone.currentChapterIndex;
            this.selection[2] = this.biblePhone.currentVerseIndex;
            this.removeCommand(this.historyCommand);
            this.removeCommand(this.addBookmarkCommand);
            this.removeCommand(this.bookmarksCommand);
            this.removeCommand(this.searchCommand);
            this.removeCommand(this.searchResultsCommand);
            this.removeCommand(this.prefsCommand);
            this.removeCommand(this.aboutCommand);
            this.removeCommand(this.exitCommand);
            if (BiblePhone.USE_MIDP20) {
                if (this.sendSMSCommand != null) {
                    this.removeCommand(this.sendSMSCommand);
                }
                if (this.sendMMSCommand != null) {
                    this.removeCommand(this.sendMMSCommand);
                }
            }
            if (this.biblePhone.fullScreen) {
                this.removeCommand(this.gotoCommand);
                this.setCommandListener(null);
            } else {
                this.addCommand(this.cancelCommand);
            }
            this.repaint();
            this.serviceRepaints();
            this.editingSelection = false;
        } else if (this.mode == 3 && this.validateSelection()) {
            this.biblePhone.gotoPassage(this.selection[0], this.selection[1], this.selection[2]);
        }
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public String replace(String _text, String _searchStr, String _replacementStr) {
        StringBuffer sb = new StringBuffer();
        int searchStringPos = _text.indexOf(_searchStr);
        int startPos = 0;
        int searchStringLength = _searchStr.length();
        while (searchStringPos != -1) {
            sb.append(_text.substring(startPos, searchStringPos)).append(_replacementStr);
            startPos = searchStringPos + searchStringLength;
            searchStringPos = _text.indexOf(_searchStr, startPos);
        }
        sb.append(_text.substring(startPos, _text.length()));
        return sb.toString();
    }

    public void paint(Graphics g) {
        this.width = this.getWidth();
        this.height = this.getHeight() - this.heightGraphicalButtons;
        if (BiblePhone.TouchScreen) {
            int i;
            g.fillRect(0, this.height, this.width, this.heightGraphicalButtons);
            g.setColor(0, 0, 255);
            g.fillRect(0, this.height, this.lineWidth / 2, this.heightGraphicalButtons);
            g.fillRect(0, this.height, this.width, this.lineWidth);
            g.fillRect(0, this.height + this.heightGraphicalButtons - this.lineWidth, this.width, this.lineWidth);
            for (i = 1; i <= this.numberOfButtons; ++i) {
                g.fillRect(0 + i * this.width / this.numberOfButtons - this.lineWidth / 2, this.height, this.lineWidth, this.heightGraphicalButtons);
            }
            if (this.mode == 3) {
                g.setColor(255, 255, 255);
                g.fillTriangle(this.width / this.numberOfButtons / 2 - 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2, this.width / this.numberOfButtons / 2 + 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 + 3 * this.lineWidth / 2, this.width / this.numberOfButtons / 2 + 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 - 3 * this.lineWidth / 2);
                g.fillTriangle(this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 - 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 + 3 * this.lineWidth / 2, this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2, this.height + this.heightGraphicalButtons / 2 - 3 * this.lineWidth / 2, this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 + 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 + 3 * this.lineWidth / 2);
                g.fillArc(this.width / this.numberOfButtons / 2 - this.lineWidth + 2 * this.width / this.numberOfButtons, this.height + this.heightGraphicalButtons / 2 - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth, 0, 360);
                g.fillTriangle(3 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 - 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 - 3 * this.lineWidth / 2, 3 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2, this.height + this.heightGraphicalButtons / 2 + 3 * this.lineWidth / 2, 3 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 + 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 - 3 * this.lineWidth / 2);
                g.fillTriangle(4 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 - 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 + 3 * this.lineWidth / 2, 4 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 - 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 - 3 * this.lineWidth / 2, 4 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 + 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2);
            } else if (this.mode == 2 || this.mode == 1) {
                g.setColor(255, 255, 255);
                g.fillRect(this.width / this.numberOfButtons / 2 - this.lineWidth, this.height + this.heightGraphicalButtons / 2 - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth);
                g.fillTriangle(this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 - 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 + 3 * this.lineWidth / 2, this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2, this.height + this.heightGraphicalButtons / 2 - 3 * this.lineWidth / 2, this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 + 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 + 3 * this.lineWidth / 2);
                g.fillArc(this.width / this.numberOfButtons / 2 - this.lineWidth + 2 * this.width / this.numberOfButtons, this.height + this.heightGraphicalButtons / 2 - this.lineWidth, 2 * this.lineWidth, 2 * this.lineWidth, 0, 360);
                g.fillTriangle(3 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 - 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 - 3 * this.lineWidth / 2, 3 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2, this.height + this.heightGraphicalButtons / 2 + 3 * this.lineWidth / 2, 3 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 + 3 * this.lineWidth / 2, this.height + this.heightGraphicalButtons / 2 - 3 * this.lineWidth / 2);
                for (i = 0; i < this.lineWidth; ++i) {
                    g.drawLine(4 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 - this.lineWidth - i, this.height + this.heightGraphicalButtons / 2 - this.lineWidth, 4 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 + this.lineWidth - i, this.height + this.heightGraphicalButtons / 2 + this.lineWidth);
                    g.drawLine(4 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 - this.lineWidth - i, this.height + this.heightGraphicalButtons / 2 + this.lineWidth, 4 * this.width / this.numberOfButtons + this.width / this.numberOfButtons / 2 + this.lineWidth - i, this.height + this.heightGraphicalButtons / 2 - this.lineWidth);
                }
            }
        }
        if (this.mode == 1) {
            this.paintLoading(g);
        } else if (this.mode == 2) {
            int numberOfVerses = 0;
            numberOfVerses = this.biblePhone.getNumberOfVerses(this.biblePhone.currentBookIndex, Integer.parseInt(BiblePhone.ChapterStart.elementAt(this.biblePhone.currentBookIndex).toString()) - 1 + this.biblePhone.currentChapterIndex);
            Font boldFont = Font.getFont((int)0, (int)1, (int)BiblePhone.FONT_SIZE_MAP[this.biblePhone.fontSize]);
            int barHeight = 4 + boldFont.getHeight();
            g.setColor(this.highlightColour);
            g.fillRect(0, 0, this.width, barHeight);
            g.setColor(this.backColour);
            g.fillRect(0, barHeight, this.width, this.height - barHeight);
            g.setFont(boldFont);
            String bookName = this.biblePhone.getBookName(this.biblePhone.currentBookIndex);
            String referenceString = " " + this.biblePhone.getReferenceString(this.biblePhone.currentBookIndex, this.biblePhone.currentChapterIndex, this.biblePhone.currentVerseIndex);
            int bookNameWidth = boldFont.stringWidth(bookName);
            int referenceStringWidth = boldFont.stringWidth(referenceString);
            int ofStringWidth = BiblePhone.getString("UI-of") == "UI-of" ? boldFont.stringWidth(" of " + numberOfVerses) : boldFont.stringWidth(" " + BiblePhone.getString("UI-of") + " " + numberOfVerses);
            int coreWidth = bookNameWidth + referenceStringWidth + 4;
            if (coreWidth + ofStringWidth <= this.width) {
                g.setColor(this.textColour);
                if (BiblePhone.getString("UI-of") == "UI-of") {
                    g.drawString(" of " + numberOfVerses, this.width - 2, 2, 24);
                } else {
                    g.drawString(" " + BiblePhone.getString("UI-of") + " " + numberOfVerses, this.width - 2, 2, 24);
                }
            } else {
                ofStringWidth = 0;
            }
            g.setColor(this.textColour);
            g.drawString(referenceString, this.width - 2 - ofStringWidth, 2, 24);
            if (coreWidth + ofStringWidth > this.width) {
                g.clipRect(0, 0, this.width - (2 + referenceStringWidth + ofStringWidth), this.height);
            }
            BibleCanvas.drawString(g, bookName, 2, 2, 20);
            Font plainFont = Font.getFont((int)0, (int)(this.biblePhone.fontStyle == 1 ? 1 : 0), (int)BiblePhone.FONT_SIZE_MAP[this.biblePhone.fontSize]);
            int textWrap = this.width - 3;
            int fontHeight = plainFont.getHeight();
            this.y = barHeight + 2;
            this.moreVerseDown = false;
            g.setClip(0, this.y, this.width, this.height - this.y);
            boolean styleRed = false;
            g.setColor(this.textColour);
            for (int verseIndex = this.biblePhone.currentVerseIndex; verseIndex < numberOfVerses && this.y + fontHeight <= this.height; ++verseIndex) {
                char currentChar;
                int charIndex;
                char[] verse = this.biblePhone.verses[verseIndex].indexOf("  ", 0) >= 0 ? this.replace(this.replace(this.replace(this.replace(this.biblePhone.verses[verseIndex], "    ", " "), "   ", " "), "  ", " "), "~  ", "~").toCharArray() : this.biblePhone.verses[verseIndex].toCharArray();
                int verseEnd = verse.length;
                int verseOffset = 0;
                this.drawX = 3;
                this.lineStart = verseOffset;
                this.lastSpace = -1;
                int startChar = verseOffset;
                startChar = 0;
                if (verseIndex == this.biblePhone.currentVerseIndex) {
                    if (this.currentScrollPointIndex > 0) {
                        this.lineStart = startChar = this.scrollPoints[this.currentScrollPointIndex];
                        styleRed = this.scrollStyleRed[this.currentScrollPointIndex];
                    } else if (this.currentScrollPoint >= 0) {
                        this.lineStart = startChar = this.currentScrollPoint;
                        styleRed = this.currentScrollStyle;
                    }
                    if (this.currentScrollPointIndex == -1) {
                        this.currentScrollPointIndex = 0;
                        this.scrollPoints[this.currentScrollPointIndex] = verseOffset;
                        this.scrollStyleRed[this.currentScrollPointIndex] = styleRed;
                    }
                    if (styleRed) {
                        g.setColor(this.christWordsColour);
                    }
                    this.scrollPoints[this.currentScrollPointIndex + 1] = 0;
                }
                if (startChar == verseOffset) {
                    g.setFont(boldFont);
                    String verseString = "";
                    verseString = BiblePhone.getStringConfig("ShowVerseNumber", BiblePhone.ConfigIni).equals("true") ? verseIndex + 1 + "" : "";
                    if (this.align == 0) {
                        g.drawString(verseString, this.drawX, this.y, 20);
                    } else if (this.align == 1) {
                        g.drawString(verseString, this.width - this.drawX, this.y, 24);
                    }
                    this.drawX = BiblePhone.getStringConfig("ShowVerseNumber", BiblePhone.ConfigIni).equals("true") ? (this.drawX += boldFont.stringWidth(verseString) + 5) : (this.drawX += boldFont.stringWidth(verseString));
                }
                if (BiblePhone.FontIndependent) {
                    if (BiblePhone.numberOfBibles > 1) {
                        BiblePhone.FontIndependent = false;
                    }
                }
                if (BiblePhone.FontIndependent) {
                    fontHeight = BiblePhone.fontImageHeight;
                    for (charIndex = startChar; charIndex < verseEnd && this.y + fontHeight <= this.height; ++charIndex) {
                        if (verse[charIndex] == '^') {
                            this.lastSpace = charIndex;
                            this.wrapCheckImage(verse, charIndex, 0, fontHeight, styleRed, g, plainFont, verseIndex, barHeight);
                        } else {
                            this.wrapCheckImage(verse, charIndex, textWrap, fontHeight, styleRed, g, plainFont, verseIndex, barHeight);
                        }
                        currentChar = verse[charIndex];
                        if (currentChar != ' ') continue;
                        this.lastSpace = charIndex;
                    }
                    if (this.y + fontHeight <= this.height && this.lineStart < verseEnd) {
                        this.wrapCheckImage(verse, verseEnd, textWrap, fontHeight, styleRed, g, plainFont, verseIndex, barHeight);
                        if (this.y + fontHeight <= this.height && this.lineStart < verseEnd) {
                            this.lineStart = verseEnd;
                            this.y += fontHeight + Integer.parseInt(BiblePhone.getStringConfig("SpaceBetweenParagraphs", BiblePhone.ConfigIni));
                        }
                    }
                    if (this.lineStart < verseEnd) {
                        if (verseIndex != this.biblePhone.currentVerseIndex) continue;
                        this.moreVerseDown = true;
                        continue;
                    }
                    if (verseIndex == numberOfVerses - 1) {
                        this.nextScrollPointVerse = -1;
                        continue;
                    }
                    this.nextScrollPointVerse = verseIndex + 1;
                    this.nextScrollPoint = -1;
                    this.nextScrollStyle = false;
                    continue;
                }
                g.setFont(plainFont);
                for (charIndex = startChar; charIndex < verseEnd && this.y + fontHeight <= this.height; ++charIndex) {
                    if (verse[charIndex] == '^') {
                        this.lastSpace = charIndex;
                        this.wrapCheck(verse, charIndex, 0, fontHeight, styleRed, g, plainFont, verseIndex, barHeight);
                    } else {
                        this.wrapCheck(verse, charIndex, textWrap, fontHeight, styleRed, g, plainFont, verseIndex, barHeight);
                    }
                    currentChar = verse[charIndex];
                    if (currentChar == '~') {
                        this.lastSpace = charIndex;
                        if (this.y + fontHeight > this.height) continue;
                        if (this.lineStart < charIndex) {
                            this.drawChars(g, verse, this.lineStart, charIndex - this.lineStart, this.drawX, this.y);
                            this.drawX += plainFont.charsWidth(verse, this.lineStart, charIndex - this.lineStart);
                            if (charIndex == verseEnd - 1) {
                                this.y += fontHeight;
                            }
                        }
                        this.lineStart = charIndex + 1;
                        if (!styleRed) {
                            g.setColor(this.christWordsColour);
                            styleRed = true;
                            continue;
                        }
                        g.setColor(this.textColour);
                        styleRed = false;
                        continue;
                    }
                    if (currentChar != ' ') continue;
                    this.lastSpace = charIndex;
                }
                if (this.y + fontHeight <= this.height && this.lineStart < verseEnd) {
                    this.wrapCheck(verse, verseEnd, textWrap, fontHeight, styleRed, g, plainFont, verseIndex, barHeight);
                    if (this.y + fontHeight <= this.height && this.lineStart < verseEnd) {
                        this.drawChars(g, verse, this.lineStart, verseEnd - this.lineStart, this.drawX, this.y);
                        this.lineStart = verseEnd;
                        if (BiblePhone.numberOfBibles > 1) {
                            boolean sg = false;
                            int i = 0;
                            while (true) {
                                if (i >= BiblePhone.numberOfBibles - 1) break;
                                if (BiblePhone.AdditionalModuleIndex[i] >= 0) {
                                    sg = true;
                                }
                                ++i;
                            }
                            this.y = !sg ? (this.y += fontHeight) : (this.y += fontHeight + Integer.parseInt(BiblePhone.getStringConfig("SpaceBetweenParagraphs", BiblePhone.ConfigIni)));
                        } else {
                            this.y += fontHeight + Integer.parseInt(BiblePhone.getStringConfig("SpaceBetweenParagraphs", BiblePhone.ConfigIni));
                        }
                    }
                }
                if (this.lineStart < verseEnd) {
                    if (verseIndex != this.biblePhone.currentVerseIndex) continue;
                    this.moreVerseDown = true;
                    continue;
                }
                if (verseIndex == numberOfVerses - 1) {
                    this.nextScrollPointVerse = -1;
                    continue;
                }
                this.nextScrollPointVerse = verseIndex + 1;
                this.nextScrollPoint = -1;
                this.nextScrollStyle = false;
            }
        } else if (this.mode == 3) {
            this.paintGoto(g);
        }
    }

    public static void drawString(Graphics g, String string, int x, int y, int anchor) {
        if (reverseCharacters) {
            char[] reversedChars = string.toCharArray();
            int length = reversedChars.length;
            for (int i = 0; i < length >> 1; ++i) {
                char temp = reversedChars[i];
                reversedChars[i] = reversedChars[length - i - 1];
                reversedChars[length - i - 1] = temp;
            }
            g.drawChars(reversedChars, 0, length, x, y, anchor);
        } else {
            g.drawString(string, x, y, anchor);
        }
    }

    private void drawChars(Graphics g, char[] verse, int offset, int length, int x, int y) {
        if (this.align == 1) {
            x = this.width - x;
        }
        if (reverseCharacters) {
            char[] reversed = new char[length];
            for (int i = 0; i < length; ++i) {
                reversed[i] = verse[offset + length - i - 1];
            }
            g.drawChars(reversed, 0, length, x, y, this.anchor);
        } else {
            g.drawChars(verse, offset, length, x, y, this.anchor);
        }
    }

    private void drawImageChars(Graphics g, char[] verse, int offset, int length, int x, int y, Font font) {
        if (this.align == 1) {
            x = this.width - x;
        }
        if (reverseCharacters) {
            char[] reversed = new char[length];
            for (int i = 0; i < length; ++i) {
                reversed[i] = verse[offset + length - i - 1];
            }
            g.drawChars(reversed, 0, length, x, y, this.anchor);
        } else {
            int advance = 0;
            for (int i = 0; i < length; ++i) {
                Character ch = new Character(verse[offset + i]);
                g.drawImage(BiblePhone.fontImage[Integer.parseInt(BiblePhone.fontImageIndex.get(Integer.toString(ch.hashCode())).toString())], x + (advance += Integer.parseInt(BiblePhone.fontImageWidth.get(Integer.toString(ch.hashCode())).toString())), y, this.anchor);
            }
        }
    }

    private void wrapCheck(char[] verse, int charIndex, int textWrap, int fontHeight, boolean styleRed, Graphics g, Font font, int verseIndex, int barHeight) {
        int x = font.charsWidth(verse, this.lineStart, charIndex - this.lineStart) + this.drawX;
        if (x >= textWrap) {
            int lineChars = this.lastSpace - this.lineStart;
            if (this.lastSpace == -1) {
                lineChars = charIndex - this.lineStart - 1;
            }
            if (this.y + fontHeight <= this.height && this.y + fontHeight > barHeight && lineChars >= 0) {
                this.drawChars(g, verse, this.lineStart, lineChars, this.drawX, this.y);
            }
            int n = this.lineStart = this.lastSpace != -1 ? this.lastSpace + 1 : charIndex - 1;
            if (this.lastSpace != -1) {
                this.lastSpace = charIndex;
            }
            this.y += fontHeight;
            this.drawX = 3;
            if (this.y + fontHeight > this.height) {
                if (verseIndex == this.biblePhone.currentVerseIndex) {
                    if (this.scrollPoints[this.currentScrollPointIndex + 1] == 0) {
                        this.scrollPoints[this.currentScrollPointIndex + 1] = this.lineStart;
                        this.scrollStyleRed[this.currentScrollPointIndex + 1] = styleRed;
                    }
                } else {
                    this.nextScrollPointVerse = verseIndex;
                    this.nextScrollPoint = this.lineStart;
                    this.nextScrollStyle = styleRed;
                }
            }
        }
    }

    private void wrapCheckImage(char[] verse, int charIndex, int textWrap, int fontHeight, boolean styleRed, Graphics g, Font font, int verseIndex, int barHeight) {
        int x = this.drawX;
        for (int i = 0; i < charIndex - this.lineStart; ++i) {
            Character ch = new Character(verse[this.lineStart + i]);
            x += Integer.parseInt(BiblePhone.fontImageWidth.get(Integer.toString(ch.hashCode())).toString());
        }
        if (x >= textWrap) {
            int lineChars = this.lastSpace - this.lineStart;
            if (this.lastSpace == -1) {
                lineChars = charIndex - this.lineStart - 1;
            }
            if (this.y + fontHeight <= this.height && this.y + fontHeight > barHeight && lineChars >= 0) {
                this.drawImageChars(g, verse, this.lineStart, lineChars, this.drawX, this.y, font);
            }
            int n = this.lineStart = this.lastSpace != -1 ? this.lastSpace + 1 : charIndex - 1;
            if (this.lastSpace != -1) {
                this.lastSpace = charIndex;
            }
            this.y += fontHeight;
            this.drawX = 3;
            if (this.y + fontHeight > this.height) {
                if (verseIndex == this.biblePhone.currentVerseIndex) {
                    if (this.scrollPoints[this.currentScrollPointIndex + 1] == 0) {
                        this.scrollPoints[this.currentScrollPointIndex + 1] = this.lineStart;
                        this.scrollStyleRed[this.currentScrollPointIndex + 1] = styleRed;
                    }
                } else {
                    this.nextScrollPointVerse = verseIndex;
                    this.nextScrollPoint = this.lineStart;
                    this.nextScrollStyle = styleRed;
                }
            }
        }
    }

    private void paintLoading(Graphics g) {
        Font font = Font.getFont((int)0, (int)1, (int)0);
        g.setFont(font);
        String message = BiblePhone.getString("UI-Loading") + "...";
        String bookName = this.biblePhone.getBookName(this.biblePhone.currentBookIndex);
        String referenceString = " " + this.biblePhone.getReferenceString(this.biblePhone.currentBookIndex, this.biblePhone.currentChapterIndex, this.biblePhone.currentVerseIndex);
        int bookNameWidth = font.stringWidth(bookName);
        int referenceStringWidth = font.stringWidth(referenceString);
        int messageWidth = font.stringWidth(message);
        int messageHeight = font.getHeight();
        if (bookNameWidth + referenceStringWidth > messageWidth) {
            messageWidth = bookNameWidth + referenceStringWidth;
        }
        int boxWidth = messageWidth + 10;
        int boxHeight = messageHeight * 4;
        boxWidth = boxWidth > this.width ? this.width : boxWidth;
        boxHeight = boxHeight > this.height ? this.height : boxHeight;
        int boxLeft = this.width - boxWidth >> 1;
        int boxTop = this.height - boxHeight >> 1;
        g.setGrayScale(128);
        g.drawRect(boxLeft + 1, boxTop + 1, boxWidth, boxHeight);
        g.setGrayScale(255);
        g.fillRect(boxLeft, boxTop, boxWidth, boxHeight);
        g.setGrayScale(0);
        g.drawRect(boxLeft, boxTop, boxWidth, boxHeight);
        g.drawString(message, this.width >> 1, this.height - 2 * messageHeight >> 1, 17);
        int referenceTop = (this.height - 2 * messageHeight >> 1) + messageHeight;
        if (bookNameWidth + referenceStringWidth < boxWidth) {
            int startX = this.width - (bookNameWidth + referenceStringWidth) >> 1;
            BibleCanvas.drawString(g, bookName, startX, referenceTop, 20);
            g.drawString(referenceString, startX + bookNameWidth, referenceTop, 20);
        } else {
            g.drawString(referenceString, boxWidth + boxLeft, referenceTop, 24);
            g.clipRect(0, 0, boxLeft + boxWidth - referenceStringWidth, this.height);
            BibleCanvas.drawString(g, bookName, boxLeft + 2, referenceTop, 20);
        }
    }

    public void paintGoto(Graphics g) {
        int verseWidth;
        int colonWidth;
        int chapterWidth;
        String currentChapter = "" + (this.selection[1] + this.biblePhone.getStartChapter(this.selection[0]));
        String currentVerse = "" + (this.selection[2] + 1);
        String[] bookNames = this.biblePhone.getBookNames();
        Font font = Font.getFont((int)0, (int)1, (int)BiblePhone.FONT_SIZE_MAP[this.biblePhone.fontSize]);
        g.setFont(font);
        int fontHeight = font.getHeight();
        int widest = 0;
        for (int i = 0; i < bookNames.length; ++i) {
            int width = font.stringWidth(bookNames[i]);
            if (width <= widest) continue;
            widest = width;
        }
        int spaceWidth = font.charWidth(' ');
        int passageWidth = widest + 2 * spaceWidth + (chapterWidth = font.stringWidth(currentChapter)) + spaceWidth + (colonWidth = font.charWidth(':')) + spaceWidth + (verseWidth = font.stringWidth(currentVerse));
        if (passageWidth > this.width - 2) {
            widest -= passageWidth - (this.width - 2);
            passageWidth = this.width - 2;
        }
        int passageLeft = this.width - passageWidth >> 1;
        int passageTop = this.height - fontHeight >> 1;
        int chapterRight = passageLeft + widest + 2 * spaceWidth + chapterWidth;
        int boxWidth = passageWidth + 20;
        int boxHeight = fontHeight + 20;
        boxWidth = this.width - 2;
        boxHeight = boxHeight > this.height - 2 ? this.height - 2 : boxHeight;
        int boxLeft = this.width - boxWidth >> 1;
        int boxTop = this.height - boxHeight >> 1;
        g.setGrayScale(128);
        g.drawRect(boxLeft + 1, boxTop + 1, boxWidth - 1, boxHeight - 1);
        g.setGrayScale(255);
        g.fillRect(boxLeft, boxTop, boxWidth - 1, boxHeight - 1);
        g.setGrayScale(0);
        g.drawRect(boxLeft, boxTop, boxWidth - 1, boxHeight - 1);
        g.setColor(0xE0E0FF);
        int halfSpace = spaceWidth >> 1;
        int doubleSpace = spaceWidth << 1;
        if (this.selectionIndex == 0) {
            g.fillRoundRect(passageLeft - spaceWidth, passageTop - spaceWidth, widest + spaceWidth, fontHeight + doubleSpace, 10, 10);
        } else if (this.selectionIndex == 1) {
            g.fillRoundRect(chapterRight - chapterWidth - halfSpace, passageTop - spaceWidth, chapterWidth + spaceWidth, fontHeight + doubleSpace, 10, 10);
        } else if (this.selectionIndex == 2) {
            g.fillRoundRect(chapterRight + spaceWidth + colonWidth + spaceWidth - halfSpace, passageTop - spaceWidth, verseWidth + spaceWidth, fontHeight + doubleSpace, 10, 10);
        }
        g.setGrayScale(0);
        g.drawString(currentChapter, chapterRight, passageTop, 24);
        g.drawString(" : " + currentVerse, chapterRight, passageTop, 20);
        g.clipRect(passageLeft, passageTop, widest, fontHeight);
        BibleCanvas.drawString(g, bookNames[this.selection[0]], passageLeft, passageTop, 20);
        if (this.biblePhone.fullScreen) {
            g.setClip(0, 0, this.width, this.height);
            g.setColor(-1);
            font = Font.getFont((int)0, (int)1, (int)16);
            g.setFont(font);
            int menuBoxHeight = font.getHeight() + 5;
            g.fillRect(0, this.height - menuBoxHeight, this.width, menuBoxHeight);
            this.drawButton(g, BiblePhone.getString("UI-Goto"), font, 1);
            font = Font.getFont((int)0, (int)0, (int)0);
            g.setFont(font);
            this.drawButton(g, BiblePhone.getString("UI-Cancel"), font, 8);
        }
    }

    public void drawButton(Graphics g, String label, Font font, int position) {
        int buttonWidth = font.stringWidth(label) + 4;
        int buttonHeight = font.getHeight() + 3;
        int buttonY = this.height - buttonHeight;
        int buttonX = 0;
        switch (position) {
            case 8: {
                buttonX = this.width - buttonWidth - 1;
                break;
            }
            case 1: {
                buttonX = (this.width >> 1) - (buttonWidth >> 1);
            }
        }
        g.setColor(0xE0E0FF);
        g.fillRoundRect(buttonX, buttonY, buttonWidth, buttonHeight + 10, 10, 10);
        g.setColor(0xC0C0FF);
        g.drawRoundRect(buttonX, buttonY, buttonWidth, buttonHeight + 10, 10, 10);
        g.setColor(-16777216);
        g.drawString(label, buttonX + 3, buttonY + 3, 20);
    }

    public void pointerPressed(int x, int y) {
        this.touchScreen(x, y);
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
        this.touchScreenDragging(x, y);
    }

    public void pressPointer(int x, int y) {
        this.touchScreen(x, y);
    }

    public void releasePointer(int x, int y) {
    }

    public void dragPointer(int x, int y) {
        this.touchScreenDragging(x, y);
    }

    public void touchScreen(int x, int y) {
        if (this.mode == 3) {
            if (y >= this.height) {
                if (x <= this.width / this.numberOfButtons) {
                    this.keyPressed(-3);
                } else if (x <= 2 * this.width / this.numberOfButtons) {
                    this.keyPressed(-1);
                } else if (x <= 3 * this.width / this.numberOfButtons) {
                    this.keyPressed(-5);
                } else if (x <= 4 * this.width / this.numberOfButtons) {
                    this.keyPressed(-2);
                } else if (x <= 5 * this.width / this.numberOfButtons) {
                    this.keyPressed(-4);
                }
            }
        } else if ((this.mode == 2 || this.mode == 1) && y >= this.height) {
            if (x <= this.width / this.numberOfButtons) {
                if (BiblePhone.USE_MIDP20) {
                    this.biblePhone.fullScreen = !this.biblePhone.fullScreen;
                    this.setFullScreenMode(this.biblePhone.fullScreen);
                }
            } else if (x <= 2 * this.width / this.numberOfButtons) {
                this.keyPressed(-1);
            } else if (x <= 3 * this.width / this.numberOfButtons) {
                this.keyPressed(-5);
            } else if (x <= 4 * this.width / this.numberOfButtons) {
                this.keyPressed(-2);
            } else if (x <= 5 * this.width / this.numberOfButtons) {
                this.biblePhone.destroyApp(false);
                this.biblePhone.notifyDestroyed();
            }
        }
    }

    public void touchScreenDragging(int x, int y) {
        if (this.mode == 3) {
            if (y >= this.height) {
                if (x > this.width / this.numberOfButtons && x > 2 * this.width / this.numberOfButtons && x > 3 * this.width / this.numberOfButtons && x > 4 * this.width / this.numberOfButtons && x <= 5 * this.width / this.numberOfButtons) {
                    // empty if block
                }
            } else if (y <= this.yPointer - this.biblePhone.delayOfDragging) {
                this.keyPressed(-1);
                this.xPointer = x;
                this.yPointer = y;
            } else if (y >= this.yPointer + this.biblePhone.delayOfDragging) {
                this.keyPressed(-2);
                this.xPointer = x;
                this.yPointer = y;
            }
        } else if (this.mode == 2 || this.mode == 1) {
            if (y >= this.height) {
                if (x > this.width / this.numberOfButtons && x > 2 * this.width / this.numberOfButtons && x > 3 * this.width / this.numberOfButtons && x > 4 * this.width / this.numberOfButtons && x <= 5 * this.width / this.numberOfButtons) {
                    // empty if block
                }
            } else if (y <= this.yPointer - this.biblePhone.delayOfDragging) {
                this.keyPressed(-2);
                this.xPointer = x;
                this.yPointer = y;
            } else if (y >= this.yPointer + this.biblePhone.delayOfDragging) {
                this.keyPressed(-1);
                this.xPointer = x;
                this.yPointer = y;
            }
        }
    }
}

