/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class BiblePhone
extends MIDlet
implements Runnable {
    public static boolean USE_MIDP20 = true;
    public static final int FONT_SIZE_SMALL = 0;
    public static final int FONT_SIZE_MEDIUM = 1;
    public static final int FONT_SIZE_LARGE = 2;
    public static final int[] FONT_SIZE_MAP = new int[]{8, 0, 16};
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int THEME_PAPER = 0;
    public static final int THEME_COMPUTER = 1;
    public static final int THEME_FLORAL = 2;
    public static final int THEME_NATURAL = 3;
    public static final int THEME_BLUE = 4;
    public static final int THEME_SUNSHINE = 5;
    public static final int[] THEME_TEXT_COLOUR = new int[]{0, 65280, 0x660066, 0x883300, 136, 26112};
    public static final int[] THEME_BACK_COLOUR = new int[]{0xFFFFFF, 0, 0xFFDDF0, 0xFFFFCC, 0xDDEEFF, 0xFFFF00};
    public static final int[] THEME_HIGHLIGHT_COLOUR = new int[]{0xE0E0FF, 21760, 0xDDC0DD, 0xCCFFCC, 0xFFFFFF, 0xBBFF00};
    public static final int[] THEME_CHRIST_COLOUR = new int[]{0xC00000, 0xFF8800, 26214, 26112, 0xD00000, 0xDD4400};
    public static int PREFS_FONT_SIZE = 0;
    public static int PREFS_BOOK = 1;
    public static int PREFS_CHAPTER = 2;
    public static int PREFS_VERSE = 3;
    public static Hashtable uiProperties = new Hashtable();
    public static Hashtable ConfigIni = new Hashtable();
    public static Hashtable ConfigBible = new Hashtable();
    public static Hashtable BookNames = new Hashtable();
    public static Hashtable ModuleBooks = new Hashtable();
    public static Hashtable idUNL = new Hashtable();
    public static Hashtable fontImageIndex = new Hashtable();
    public static Hashtable fontImageWidth = new Hashtable();
    public static int fontImageHeight = 0;
    public static Image[] fontImage;
    public static int numberImageFonts;
    public static String[] BibleNames;
    public static int BasicModuleIndex;
    public static int[] AdditionalModuleIndex;
    public static boolean ModuleChange;
    public static boolean FontIndependent;
    public static int numberUNL;
    public static int numberOfBibles;
    public static int numberOfBooks;
    public static Vector[] numberOfVerses;
    public static Vector[] indexOfChapters;
    public static Vector IndexBooksAvailable;
    public static Vector BooksAvailable;
    public static Vector ChapterStart;
    public static Vector ChapterEnd;
    public Display display;
    public BibleCanvas bibleCanvas;
    private PrefsForm prefsForm;
    private boolean firstRun = true;
    public int currentBookIndex = 0;
    public int currentChapterIndex = 0;
    public int currentVerseIndex = 0;
    public int fontSize = 1;
    public int fontStyle = 0;
    public boolean fullScreen = false;
    public int theme = 0;
    public boolean reverseColours = false;
    public static int[] verseIndex;
    public static char[] verseData;
    public String lastSearchString = "";
    public int lastFromBook = -1;
    public int lastToBook = -1;
    Vector searchResults = new Vector();
    public boolean caseInsensitiveSearching = false;
    Vector bookmarks = new Vector();
    public static final int HISTORY_SIZE = 20;
    public static final int HISTORY_EXCERPT_SIZE = 30;
    public int historyStartIndex = 0;
    public byte[] historyVerseIndices = new byte[60];
    public String[] historyExcerpts = new String[20];
    Timer backlightTimer;
    TimerTask backlightTask;
    public long fromJarTime;
    public long readUTFTime;
    public long readBytesTime;
    public long byteToStringTime;
    public long byteToCharTime;
    public long loadChapterTime;
    public long skipTime;
    DataInputStream inputFile = null;
    public String[] verses;
    public String[] bookNames;
    public int[] start_versete;
    public int[] end_versete;
    int bookIndexAnte;
    int chapterIndexAnte;
    public static boolean TouchScreen;
    int heightGraphicalButtons = 0;
    int delayOfDragging = 0;

    public void startApp() {
        this.bookIndexAnte = -1;
        this.chapterIndexAnte = -1;
        if (this.firstRun) {
            Form form;
            this.firstRun = false;
            this.readProperties(new String("config.ini"), ConfigIni);
            USE_MIDP20 = false;
            if (BiblePhone.getStringConfig("MIDP", ConfigIni).equals("2.0")) {
                USE_MIDP20 = true;
            }
            BasicModuleIndex = 0;
            try {
                this.readModulePreferences();
            }
            catch (Throwable e) {
                form = new Form("Error");
                form.append(e.toString());
                this.display.setCurrent((Displayable)form);
            }
            numberOfBibles = Integer.parseInt(BiblePhone.getStringConfig("numberOfBibles", ConfigIni));
            if (numberOfBibles > 1) {
                AdditionalModuleIndex = new int[numberOfBibles - 1];
                for (int i = 0; i < numberOfBibles - 1; ++i) {
                    BiblePhone.AdditionalModuleIndex[i] = -1;
                }
                BibleNames = new String[numberOfBibles];
                for (int nrBible = 0; nrBible < numberOfBibles; ++nrBible) {
                    BiblePhone.BibleNames[nrBible] = new String(BiblePhone.getStringConfig("bibleName" + nrBible, ConfigIni));
                }
            }
            if (FontIndependent = BiblePhone.getStringConfig("FontIndependent", ConfigIni).equals("true")) {
                this.readIndexFonts();
            }
            if (TouchScreen = BiblePhone.getStringConfig("TouchScreen", ConfigIni).equals("true")) {
                this.heightGraphicalButtons = Integer.parseInt(BiblePhone.getStringConfig("heightGraphicalButtons", ConfigIni));
                this.delayOfDragging = Integer.parseInt(BiblePhone.getStringConfig("delayOfDragging", ConfigIni));
            }
            this.initialization();
            this.display = Display.getDisplay((MIDlet)this);
            try {
                this.bibleCanvas = new BibleCanvas(this);
                this.bibleCanvas.init();
                this.display.setCurrent((Displayable)this.bibleCanvas);
                this.readPreferences();
                this.readModulePreferences();
                this.readBookmarks();
                this.readHistory();
                if (USE_MIDP20) {
                    this.bibleCanvas.setFullScreenMode(this.fullScreen);
                }
                new Thread(this).start();
            }
            catch (Throwable e) {
                form = new Form("Error");
                form.append(e.toString());
                this.display.setCurrent((Displayable)form);
            }
        }
    }

    public void initialization() {
        int i;
        ConfigBible.clear();
        this.readProperties(new String("config/" + BiblePhone.getStringConfig("bible" + BasicModuleIndex, ConfigIni) + ".txt"), ConfigBible);
        uiProperties.clear();
        this.readProperties(new String("menus/" + BiblePhone.getStringConfig("menus" + BasicModuleIndex, ConfigIni) + ".txt"), uiProperties);
        BookNames.clear();
        this.readProperties(new String("books/" + BiblePhone.getStringConfig("books" + BasicModuleIndex, ConfigIni) + ".txt"), BookNames);
        numberOfBooks = 0;
        int dimensiune = ConfigBible.size();
        ChapterStart.removeAllElements();
        ChapterEnd.removeAllElements();
        IndexBooksAvailable.removeAllElements();
        BooksAvailable.removeAllElements();
        for (i = 1; i < dimensiune; ++i) {
            String buff = new String(BiblePhone.getStringConfig("" + i, ConfigBible));
            if (buff.indexOf(9) == -1) {
                ++dimensiune;
                continue;
            }
            IndexBooksAvailable.addElement("" + i);
            BooksAvailable.addElement(buff.substring(0, buff.indexOf(9)));
            String buff1 = buff.substring(buff.indexOf(9) + 1);
            ChapterStart.addElement(buff1.substring(0, buff1.indexOf(9)));
            ChapterEnd.addElement(buff1.substring(buff1.indexOf(9) + 1));
            ++numberOfBooks;
        }
        this.readUNL();
        numberOfVerses = new Vector[numberUNL];
        indexOfChapters = new Vector[numberUNL];
        this.readNumberOfVerses();
        for (i = 0; i < numberOfBooks; ++i) {
            int selectionBook = Integer.parseInt(ModuleBooks.get(BooksAvailable.elementAt(i)).toString());
            int numberOfChapters = numberOfVerses[selectionBook].size();
            if (Integer.parseInt(ChapterStart.elementAt(i).toString()) == 0) {
                ChapterStart.setElementAt("1", i);
            }
            if (Integer.parseInt(ChapterEnd.elementAt(i).toString()) == 0) {
                ChapterEnd.setElementAt("" + numberOfVerses[selectionBook].size(), i);
            }
            IndexBooksAvailable.setElementAt(idUNL.get(BooksAvailable.elementAt(i)), i);
        }
        this.bookNames = new String[numberOfBooks];
        for (int bookIndex = 0; bookIndex < numberOfBooks; ++bookIndex) {
            this.bookNames[bookIndex] = BiblePhone.getStringConfig("" + IndexBooksAvailable.elementAt(bookIndex), BookNames);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.writePreferences();
        this.writeBookmarks();
        this.writeHistory();
        this.writeModulePreferences();
        if (this.backlightTimer != null) {
            this.backlightTimer.cancel();
        }
    }

    public void run() {
        boolean error = false;
        this.loadCurrentChapter();
        this.showMainScreen();
    }

    public String replace(String _text, String _searchStr, String _replacementStr) {
        StringBuffer sb = new StringBuffer();
        int searchStringPos = _text.indexOf(_searchStr);
        int startPos = 0;
        int searchStringLength = _searchStr.length();
        while (searchStringPos != -1) {
            sb.append(_text.substring(startPos, searchStringPos)).append(_replacementStr);
            startPos = searchStringPos + searchStringLength;
            searchStringPos = _text.indexOf(_searchStr, startPos);
        }
        sb.append(_text.substring(startPos, _text.length()));
        return sb.toString();
    }

    public void readIndexFonts() {
        try {
            int length1;
            String buffer1;
            int indexNext;
            DataInputStream input = new DataInputStream(this.getClass().getResourceAsStream("/fonts/" + BiblePhone.getStringConfig("language" + BasicModuleIndex, ConfigIni) + ".txt"));
            int length = input.available();
            byte[] byteArray = new byte[length];
            input.readFully(byteArray, 0, length);
            input.close();
            String buffer = new String(byteArray);
            length = buffer.length();
            int index = 0;
            int nrFonts = -1;
            while (index < length) {
                indexNext = buffer.indexOf("\r\n", index);
                if (indexNext > 0) {
                    buffer1 = buffer.substring(index, indexNext);
                    length1 = indexNext - index;
                } else {
                    buffer1 = buffer.substring(index, length);
                    length1 = length - index;
                }
                ++nrFonts;
                index = indexNext + 2;
                if (indexNext >= 0) continue;
                break;
            }
            numberImageFonts = nrFonts;
            fontImage = new Image[numberImageFonts];
            index = 0;
            nrFonts = -1;
            while (index < length) {
                indexNext = buffer.indexOf("\r\n", index);
                if (indexNext > 0) {
                    buffer1 = buffer.substring(index, indexNext);
                    length1 = indexNext - index;
                } else {
                    buffer1 = buffer.substring(index, length);
                    length1 = length - index;
                }
                int index1 = 0;
                int nrFields = 0;
                String[] buffer2 = new String[2];
                if (nrFonts >= 0) {
                    while (index1 < length1) {
                        int indexNext1 = buffer1.indexOf(9, index1);
                        buffer2[nrFields] = indexNext1 > 0 ? buffer1.substring(index1, indexNext1) : buffer1.substring(index1, length1);
                        ++nrFields;
                        index1 = indexNext1 + 1;
                        if (indexNext1 >= 0) continue;
                        break;
                    }
                    if (nrFields == 2) {
                        BiblePhone.fontImage[nrFonts] = Image.createImage((String)("/fonts/database/" + buffer2[1] + ".gif"));
                        fontImageIndex.put(buffer2[1], Integer.toString(nrFonts));
                        fontImageWidth.put(buffer2[1], Integer.toString(fontImage[nrFonts].getWidth()));
                        if (fontImageHeight < fontImage[nrFonts].getHeight()) {
                            fontImageHeight = fontImage[nrFonts].getHeight();
                        }
                    }
                }
                ++nrFonts;
                index = indexNext + 2;
                if (indexNext >= 0) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readUNL() {
        try {
            DataInputStream input = new DataInputStream(this.getClass().getResourceAsStream("unl.txt"));
            int length = input.available();
            byte[] byteArray = new byte[length];
            input.readFully(byteArray, 0, length);
            input.close();
            String fileDataWeb = new String(byteArray);
            length = fileDataWeb.length();
            int index = 0;
            int nrBooks1 = 0;
            while (index < length) {
                int length1;
                String fileDataWeb1;
                int indexNext = fileDataWeb.indexOf("\r\n", index);
                if (indexNext > 0) {
                    fileDataWeb1 = fileDataWeb.substring(index, indexNext);
                    length1 = indexNext - index;
                } else {
                    fileDataWeb1 = fileDataWeb.substring(index, length);
                    length1 = length - index;
                }
                int index1 = 0;
                int nrChapters = 0;
                String[] fileDataWeb2 = new String[4];
                while (index1 < length1) {
                    int indexNext1 = fileDataWeb1.indexOf(9, index1);
                    fileDataWeb2[nrChapters] = indexNext1 > 0 ? fileDataWeb1.substring(index1, indexNext1) : fileDataWeb1.substring(index1, length1);
                    ++nrChapters;
                    index1 = indexNext1 + 1;
                    if (indexNext1 >= 0) continue;
                    break;
                }
                if (nrChapters == 4) {
                    idUNL.put(fileDataWeb2[2], fileDataWeb2[0]);
                }
                ++nrBooks1;
                index = indexNext + 2;
                if (indexNext >= 0) continue;
                break;
            }
            numberUNL = nrBooks1;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readNumberOfVerses() {
        try {
            DataInputStream input = new DataInputStream(this.getClass().getResourceAsStream("bibles/" + BiblePhone.getStringConfig("bible" + BasicModuleIndex, ConfigIni) + "/numberOfVerses.txt"));
            int length = input.available();
            byte[] byteArray = new byte[length];
            input.readFully(byteArray, 0, length);
            input.close();
            String fileDataWeb = new String(byteArray);
            length = fileDataWeb.length();
            int index = 0;
            int nrBooks1 = 0;
            while (index < length) {
                int length1;
                String fileDataWeb1;
                int indexNext = fileDataWeb.indexOf("\r\n", index);
                BiblePhone.numberOfVerses[nrBooks1] = new Vector();
                BiblePhone.indexOfChapters[nrBooks1] = new Vector();
                if (indexNext > 0) {
                    fileDataWeb1 = fileDataWeb.substring(index, indexNext);
                    length1 = indexNext - index;
                } else {
                    fileDataWeb1 = fileDataWeb.substring(index, length);
                    length1 = length - index;
                }
                int index1 = 0;
                int nrChapters1 = 0;
                while (index1 < length1) {
                    int indexNext1 = fileDataWeb1.indexOf(9, index1);
                    String fileDataWeb2 = indexNext1 > 0 ? fileDataWeb1.substring(index1, indexNext1) : fileDataWeb1.substring(index1, length1);
                    if (nrChapters1 == 0) {
                        ModuleBooks.put(fileDataWeb2, "" + nrBooks1);
                    } else {
                        int indexNext2 = fileDataWeb2.indexOf(",", 0);
                        numberOfVerses[nrBooks1].addElement("" + fileDataWeb2.substring(0, indexNext2));
                        indexOfChapters[nrBooks1].addElement("" + fileDataWeb2.substring(indexNext2 + 1, fileDataWeb2.length()));
                    }
                    ++nrChapters1;
                    index1 = indexNext1 + 1;
                    if (indexNext1 >= 0) continue;
                    break;
                }
                ++nrBooks1;
                index = indexNext + 2;
                if (indexNext >= 0) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void showMainScreen() {
        int textColour = THEME_TEXT_COLOUR[this.theme];
        int backColour = THEME_BACK_COLOUR[this.theme];
        if (this.reverseColours) {
            int temp = textColour;
            textColour = backColour;
            this.bibleCanvas.highlightColour = backColour = temp;
        } else {
            this.bibleCanvas.highlightColour = THEME_HIGHLIGHT_COLOUR[this.theme];
        }
        this.bibleCanvas.textColour = textColour;
        this.bibleCanvas.backColour = backColour;
        this.bibleCanvas.christWordsColour = THEME_CHRIST_COLOUR[this.theme];
        this.display.setCurrent((Displayable)this.bibleCanvas);
        if (USE_MIDP20) {
            this.bibleCanvas.setFullScreenMode(this.fullScreen);
        }
        this.bibleCanvas.update();
    }

    public void addBookmark() {
        try {
            BookmarkEntry bookmark = new BookmarkEntry(this.currentBookIndex, this.currentChapterIndex, this.currentVerseIndex, this.getExcerpt(this.currentBookIndex, this.currentChapterIndex, this.currentVerseIndex));
            int currentValue = this.currentBookIndex * 1000000 + this.currentChapterIndex * 1000 + this.currentVerseIndex;
            int index = -1;
            if (this.bookmarks.isEmpty()) {
                this.bookmarks.insertElementAt(bookmark, 0);
            } else {
                int dim = this.bookmarks.size();
                for (int i = 0; i < dim; ++i) {
                    BookmarkEntry bookmarkElement = (BookmarkEntry)this.bookmarks.elementAt(i);
                    if (bookmarkElement.value() <= currentValue) continue;
                    index = i;
                    System.out.println(currentValue + " " + bookmarkElement.value());
                    break;
                }
                if (index < 0) {
                    this.bookmarks.addElement(bookmark);
                } else {
                    this.bookmarks.insertElementAt(bookmark, index);
                }
            }
            this.showBookmarksScreen();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void showBookmarksScreen() {
        this.display.setCurrent((Displayable)new BookmarksList(this));
    }

    public void showHistoryScreen() {
        this.display.setCurrent((Displayable)new HistoryList(this));
    }

    public void showSendSMSScreen() {
        if (USE_MIDP20) {
            this.display.setCurrent((Displayable)new SendSMSForm(this, 0));
        }
    }

    public void showSendMMSScreen() {
        if (USE_MIDP20) {
            this.display.setCurrent((Displayable)new SendSMSForm(this, 1));
        }
    }

    public void showSearchScreen() {
        this.display.setCurrent((Displayable)new SearchForm(this));
    }

    public void showSearchResultsScreen() {
        this.display.setCurrent((Displayable)new SearchResultsList(this, this.searchResults));
    }

    public void showPrefsScreen() {
        PrefsForm prefsForm = new PrefsForm(this);
        this.display.setCurrent((Displayable)prefsForm);
    }

    public void showMultilingualScreen() {
        this.display.setCurrent((Displayable)new MultilingualForm(this));
    }

    public void showAboutAlert() {
        String infoString = this.getAppProperty("Bible-Phone-Info");
        if (infoString == null) {
            infoString = "";
        }
        Alert aboutAlert = BiblePhone.getStringConfig("credits" + BasicModuleIndex, ConfigIni).compareTo("credits" + BasicModuleIndex) == 0 ? new Alert(BiblePhone.getString("UI-About") + " Bible Phone " + BiblePhone.getStringConfig("bibleName" + BasicModuleIndex, ConfigIni), BiblePhone.getStringConfig("bibleName" + BasicModuleIndex, ConfigIni) + "\n http://www.biblephone.net\n \"Fear God, and give glory to him; for the hour of his judgment is come: and worship him that made heaven, and earth, and the sea, and the fountains of waters.\"(Rev. 14:7)\n " + infoString, null, AlertType.INFO) : new Alert(BiblePhone.getString("UI-About") + " Bible Phone " + BiblePhone.getStringConfig("bibleName" + BasicModuleIndex, ConfigIni), BiblePhone.getStringConfig("bibleName" + BasicModuleIndex, ConfigIni) + "\n http://www.biblephone.net\n " + BiblePhone.getStringConfig("credits" + BasicModuleIndex, ConfigIni) + "\n " + infoString, null, AlertType.INFO);
        try {
            aboutAlert.setImage(Image.createImage((String)("/flags/" + BiblePhone.getStringConfig("language" + BasicModuleIndex, ConfigIni) + ".gif")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.display.setCurrent((Displayable)aboutAlert);
    }

    public void gotoPassage(int bookIndex, int chapterIndex, int verseIndex) {
        boolean error = false;
        String bookName = null;
        if (bookIndex != this.currentBookIndex || chapterIndex != this.currentChapterIndex || verseIndex != this.currentVerseIndex) {
            int numberOfVerses;
            this.currentBookIndex = bookIndex;
            this.currentChapterIndex = chapterIndex;
            this.currentVerseIndex = verseIndex;
            int numberOfChapters = this.getNumberOfChapters(bookIndex);
            if (chapterIndex >= numberOfChapters) {
                error = true;
                this.currentChapterIndex = numberOfChapters - 1;
            }
            if (verseIndex >= (numberOfVerses = this.getNumberOfVerses(this.currentBookIndex, this.currentChapterIndex))) {
                error = true;
                this.currentVerseIndex = numberOfVerses - 1;
            }
            bookName = this.getBookName(bookIndex);
        }
        this.bibleCanvas.enterLoadingMode();
        this.loadCurrentChapter();
        try {
            --this.historyStartIndex;
            if (this.historyStartIndex < 0) {
                this.historyStartIndex = 19;
            }
            this.historyVerseIndices[this.historyStartIndex * 3] = (byte)this.currentBookIndex;
            this.historyVerseIndices[this.historyStartIndex * 3 + 1] = (byte)this.currentChapterIndex;
            this.historyVerseIndices[this.historyStartIndex * 3 + 2] = (byte)this.currentVerseIndex;
            this.historyExcerpts[this.historyStartIndex] = this.getExcerpt(this.currentBookIndex, this.currentChapterIndex, this.currentVerseIndex);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.bibleCanvas.update();
    }

    public String getExcerpt(int bookIndex, int chapterIndex, int verseIndex) throws IOException {
        this.loadChapter(bookIndex, chapterIndex);
        int lengthExcerpt = this.getVerseLength(verseIndex) > Integer.parseInt(BiblePhone.getStringConfig("dimensionExcerptBookmark", ConfigIni)) ? Integer.parseInt(BiblePhone.getStringConfig("dimensionExcerptBookmark", ConfigIni)) : this.getVerseLength(verseIndex);
        String excerpt = new String(this.getVerseString(verseIndex).substring(0, lengthExcerpt));
        if (this.getVerseLength(verseIndex) > Integer.parseInt(BiblePhone.getStringConfig("dimensionExcerptBookmark", ConfigIni))) {
            excerpt = excerpt + " .. ";
        }
        return excerpt;
    }

    public void scrollPrevious() {
        --this.currentVerseIndex;
        if (this.currentVerseIndex < 0) {
            this.previousChapter(true);
        }
    }

    public void scrollNext() {
        ++this.currentVerseIndex;
        if (this.currentVerseIndex >= this.getNumberOfVerses(this.currentBookIndex, this.currentChapterIndex)) {
            this.nextChapter();
        }
    }

    public void previousChapter(boolean lastVerse) {
        --this.currentChapterIndex;
        if (this.currentChapterIndex < 0) {
            this.previousBook(false);
            this.currentChapterIndex = this.getNumberOfChapters(this.currentBookIndex) - 1;
        }
        this.loadCurrentChapter();
        this.currentVerseIndex = lastVerse ? this.getNumberOfVerses(this.currentBookIndex, this.currentChapterIndex + Integer.parseInt(ChapterStart.elementAt(this.currentBookIndex).toString()) - 1) - 1 : 0;
        this.loadCurrentChapter();
    }

    public void nextChapter() {
        ++this.currentChapterIndex;
        if (this.currentChapterIndex >= this.getNumberOfChapters(this.currentBookIndex)) {
            this.nextBook(false);
        }
        this.currentVerseIndex = 0;
        this.loadCurrentChapter();
    }

    public void previousBook(boolean load) {
        --this.currentBookIndex;
        if (this.currentBookIndex < 0) {
            this.currentBookIndex = this.getNumberOfBooks() - 1;
        }
        this.currentChapterIndex = 0;
        this.currentVerseIndex = 0;
        if (load) {
            this.loadCurrentChapter();
        }
    }

    public void nextBook(boolean load) {
        ++this.currentBookIndex;
        if (this.currentBookIndex >= this.getNumberOfBooks()) {
            this.currentBookIndex = 0;
        }
        this.currentChapterIndex = 0;
        this.currentVerseIndex = 0;
        if (load) {
            this.loadCurrentChapter();
        }
    }

    private void readProperties(String fisier, Hashtable tabel) {
        try {
            DataInputStream input = new DataInputStream(this.getClass().getResourceAsStream("" + fisier));
            byte[] fileData = new byte[32768];
            int offset = 0;
            int bytesRead = 0;
            do {
                bytesRead = input.read(fileData, offset, fileData.length - offset);
                offset += bytesRead;
            } while (bytesRead >= 0);
            input.close();
            String uiPropertiesString = new String(fileData, 0, offset, "UTF-8");
            int startOfLineIndex = 0;
            int endOfLineIndex = uiPropertiesString.indexOf(10);
            while (endOfLineIndex != -1) {
                this.readPropertiesLine(uiPropertiesString, startOfLineIndex, endOfLineIndex, tabel);
                startOfLineIndex = endOfLineIndex + 1;
                endOfLineIndex = uiPropertiesString.indexOf(10, startOfLineIndex);
            }
            this.readPropertiesLine(uiPropertiesString, startOfLineIndex, uiPropertiesString.length(), tabel);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readPropertiesLine(String uiPropertiesString, int startOfLineIndex, int endOfLineIndex, Hashtable tabel) {
        String lineString = uiPropertiesString.substring(startOfLineIndex, endOfLineIndex);
        int colonIndex = lineString.indexOf(9);
        if (colonIndex >= 0) {
            String propertyName = lineString.substring(0, colonIndex).trim();
            String uiString = lineString.substring(colonIndex + 1, lineString.length()).trim();
            tabel.put(propertyName, uiString);
        }
    }

    public static String getString(String propertyName) {
        String result = (String)uiProperties.get(propertyName);
        if (result == null) {
            result = propertyName;
        }
        return result;
    }

    public static String getStringConfig(String propertyName, Hashtable tabel) {
        String result = (String)tabel.get(propertyName);
        if (result == null) {
            result = propertyName;
        }
        return result;
    }

    private void readPreferences() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"Preferences", (boolean)true);
            if (store.getNumRecords() > 0) {
                byte[] data = store.getRecord(1);
                DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
                this.fontSize = input.readByte();
                this.currentBookIndex = input.read();
                this.currentChapterIndex = input.read();
                this.currentVerseIndex = input.read();
                this.lastSearchString = input.readUTF();
                this.fullScreen = input.readBoolean();
                BibleCanvas.reverseCharacters = input.readBoolean();
                this.theme = input.readByte();
                this.reverseColours = input.readBoolean();
                this.fontStyle = input.readByte();
                this.lastFromBook = input.readByte();
                this.lastToBook = input.readByte();
                input.close();
            }
        }
        catch (IOException ee) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void readModulePreferences() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"ModulePreferences", (boolean)true);
            if (store.getNumRecords() > 0) {
                byte[] data = store.getRecord(1);
                DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
                BasicModuleIndex = input.read();
                for (int i = 0; i < numberOfBibles - 1; ++i) {
                    BiblePhone.AdditionalModuleIndex[i] = input.read();
                    if (AdditionalModuleIndex[i] != 255) continue;
                    BiblePhone.AdditionalModuleIndex[i] = -1;
                }
                input.close();
            }
        }
        catch (IOException ee) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void writePreferences() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"Preferences", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
            output.write(this.fontSize);
            output.write(this.currentBookIndex);
            output.write(this.currentChapterIndex);
            output.write(this.currentVerseIndex);
            output.writeUTF(this.lastSearchString);
            output.writeBoolean(this.fullScreen);
            output.writeBoolean(BibleCanvas.reverseCharacters);
            output.write(this.theme);
            output.writeBoolean(this.reverseColours);
            output.write(this.fontStyle);
            output.write(this.lastFromBook);
            output.write(this.lastToBook);
            output.close();
            byte[] data = byteArrayOutputStream.toByteArray();
            if (store.getNumRecords() > 0) {
                store.setRecord(1, data, 0, data.length);
            } else {
                store.addRecord(data, 0, data.length);
            }
        }
        catch (IOException e) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void writeModulePreferences() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"ModulePreferences", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
            output.write(BasicModuleIndex);
            for (int i = 0; i < numberOfBibles - 1; ++i) {
                if (AdditionalModuleIndex[i] == -1) {
                    output.write(255);
                    continue;
                }
                output.write(AdditionalModuleIndex[i]);
            }
            output.close();
            byte[] data = byteArrayOutputStream.toByteArray();
            if (store.getNumRecords() > 0) {
                store.setRecord(1, data, 0, data.length);
            } else {
                store.addRecord(data, 0, data.length);
            }
        }
        catch (IOException e) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void readBookmarks() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"Bookmarks", (boolean)true);
            if (store.getNumRecords() > 0) {
                byte[] data = store.getRecord(1);
                DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
                int numberOfBookmarks = input.readUnsignedShort();
                for (int i = 0; i < numberOfBookmarks; ++i) {
                    BookmarkEntry bookmark = new BookmarkEntry(input);
                    this.bookmarks.addElement(bookmark);
                }
                input.close();
            }
        }
        catch (IOException ee) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void writeBookmarks() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"Bookmarks", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
            output.writeShort(this.bookmarks.size());
            Enumeration e = this.bookmarks.elements();
            while (e.hasMoreElements()) {
                BookmarkEntry bookmark = (BookmarkEntry)e.nextElement();
                bookmark.write(output);
            }
            output.close();
            byte[] data = byteArrayOutputStream.toByteArray();
            if (store.getNumRecords() > 0) {
                store.setRecord(1, data, 0, data.length);
            } else {
                store.addRecord(data, 0, data.length);
            }
        }
        catch (IOException e) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void readHistory() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"History", (boolean)true);
            if (store.getNumRecords() > 0) {
                byte[] data = store.getRecord(1);
                DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
                this.historyStartIndex = input.readByte();
                int j = 0;
                for (int i = 0; i < 20; ++i) {
                    this.historyVerseIndices[j++] = input.readByte();
                    this.historyVerseIndices[j++] = input.readByte();
                    this.historyVerseIndices[j++] = input.readByte();
                    this.historyExcerpts[i] = input.readUTF();
                }
                input.close();
            }
        }
        catch (IOException ee) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void writeHistory() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"History", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
            output.writeByte(this.historyStartIndex);
            int j = 0;
            for (int i = 0; i < 20; ++i) {
                output.writeByte(this.historyVerseIndices[j++]);
                output.writeByte(this.historyVerseIndices[j++]);
                output.writeByte(this.historyVerseIndices[j++]);
                output.writeUTF(this.historyExcerpts[i] == null ? "" : this.historyExcerpts[i]);
            }
            output.close();
            byte[] data = byteArrayOutputStream.toByteArray();
            if (store.getNumRecords() > 0) {
                store.setRecord(1, data, 0, data.length);
            } else {
                store.addRecord(data, 0, data.length);
            }
        }
        catch (IOException e) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void loadCurrentChapter() {
        if (this.currentChapterIndex > Integer.parseInt(ChapterEnd.elementAt(this.currentBookIndex).toString()) + 1) {
            this.currentChapterIndex = 0;
            this.currentVerseIndex = 0;
        }
        this.loadChapter(this.currentBookIndex, this.currentChapterIndex);
    }

    public char[] getVerse(int verseIndex) {
        return this.verses[verseIndex].toCharArray();
    }

    public String getVerseString(int verseIndex) {
        return this.replace(this.replace(this.replace(this.replace(this.replace(this.verses[verseIndex], "~", ""), "    ", " "), "   ", " "), "  ", " "), "^", "\n");
    }

    public int getVerseLength(int verseIndex) {
        return this.getVerseString(verseIndex).length();
    }

    public void loadChapter(int bookIndexNew, int chapterIndexNew) {
        block11: {
            if (bookIndexNew == this.bookIndexAnte && chapterIndexNew == this.chapterIndexAnte && !ModuleChange) {
                return;
            }
            if (ModuleChange) {
                ModuleChange = false;
            }
            this.bookIndexAnte = bookIndexNew;
            this.chapterIndexAnte = chapterIndexNew;
            String valoare = "";
            try {
                if (this.display.getCurrent() == this.bibleCanvas) {
                    this.bibleCanvas.enterLoadingMode();
                }
                int bookIndexNew1 = Integer.parseInt(ModuleBooks.get(BooksAvailable.elementAt(bookIndexNew)).toString());
                int chapterIndexNew1 = chapterIndexNew + Integer.parseInt(ChapterStart.elementAt(bookIndexNew).toString()) - 1;
                int start = chapterIndexNew1 == 0 ? 0 : Integer.parseInt(indexOfChapters[bookIndexNew1].elementAt(chapterIndexNew1 - 1).toString());
                int end = Integer.parseInt(indexOfChapters[bookIndexNew1].elementAt(chapterIndexNew1).toString());
                int length = end - start;
                this.inputFile = new DataInputStream(this.getClass().getResourceAsStream("bibles/" + BiblePhone.getStringConfig("bible" + BasicModuleIndex, ConfigIni) + "/" + BooksAvailable.elementAt(bookIndexNew) + "/" + chapterIndexNew1));
                byte[] byteArray = new byte[length];
                valoare = new String("get");
                this.inputFile.read(byteArray, 0, length);
                valoare = new String("readFully");
                this.inputFile.close();
                valoare = new String("close");
                String Capitol = new String(byteArray, "UTF-8");
                int nrVersete1 = Integer.parseInt(numberOfVerses[bookIndexNew1].elementAt(chapterIndexNew1).toString());
                this.verses = new String[nrVersete1];
                int index1 = 0;
                int indexNext1 = 0;
                for (int k = 0; k < nrVersete1; ++k) {
                    indexNext1 = Capitol.indexOf("\r", index1);
                    this.verses[k] = Capitol.substring(index1, indexNext1).substring(Capitol.substring(index1, indexNext1).indexOf(" ") + 1);
                    index1 = indexNext1 + 1;
                }
                if (numberOfBibles <= 1) break block11;
                for (int nrBibles = 1; nrBibles < numberOfBibles; ++nrBibles) {
                    if (AdditionalModuleIndex[nrBibles - 1] < 0) continue;
                    boolean sg = false;
                    try {
                        this.inputFile = new DataInputStream(this.getClass().getResourceAsStream("bibles/" + BiblePhone.getStringConfig("bible" + AdditionalModuleIndex[nrBibles - 1], ConfigIni) + "/" + BooksAvailable.elementAt(bookIndexNew) + "/" + chapterIndexNew1));
                        length = this.inputFile.available();
                    }
                    catch (NullPointerException e) {
                        sg = true;
                    }
                    if (sg) continue;
                    byteArray = new byte[length];
                    valoare = new String("get");
                    this.inputFile.read(byteArray, 0, length);
                    valoare = new String("readFully");
                    this.inputFile.close();
                    valoare = new String("close");
                    Capitol = new String(byteArray, "UTF-8");
                    index1 = 0;
                    indexNext1 = 0;
                    int k = 0;
                    while (k < nrVersete1 && (indexNext1 = Capitol.indexOf("\r", index1)) > 0) {
                        int n = k++;
                        this.verses[n] = this.verses[n] + "^" + Capitol.substring(index1, indexNext1).substring(Capitol.substring(index1, indexNext1).indexOf(" ") + 1);
                        index1 = indexNext1 + 1;
                    }
                }
            }
            catch (IOException e) {
                this.display.setCurrent((Displayable)new Alert(BiblePhone.getString("UI-Error"), e.toString() + " " + valoare + " bibles/" + BiblePhone.getStringConfig("bible" + BasicModuleIndex, ConfigIni) + "/" + BooksAvailable.elementAt(bookIndexNew) + "/" + chapterIndexNew, null, AlertType.ERROR));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.display.setCurrent((Displayable)new Alert(BiblePhone.getString("UI-Error"), e.toString() + " " + valoare + " bibles/" + BiblePhone.getStringConfig("bible" + BasicModuleIndex, ConfigIni) + "/" + BooksAvailable.elementAt(bookIndexNew) + "/" + chapterIndexNew, null, AlertType.ERROR));
            }
        }
    }

    public String[] getBookNames() {
        return this.bookNames;
    }

    public String getBookName(int bookIndex) {
        if (bookIndex >= IndexBooksAvailable.size()) {
            this.currentBookIndex = 0;
            this.currentChapterIndex = 0;
            this.currentVerseIndex = 0;
            bookIndex = 0;
        }
        int selectionBook = Integer.parseInt(IndexBooksAvailable.elementAt(bookIndex).toString());
        return BiblePhone.getStringConfig("" + selectionBook, BookNames);
    }

    public int getNumberOfBooks() {
        return numberOfBooks;
    }

    public int getStartChapter(int bookIndex) {
        return Integer.parseInt(ChapterStart.elementAt(bookIndex).toString());
    }

    public int getNumberOfChapters(int bookIndex) {
        return Integer.parseInt(ChapterEnd.elementAt(bookIndex).toString()) - Integer.parseInt(ChapterStart.elementAt(bookIndex).toString()) + 1;
    }

    public int getNumberOfVerses(int bookIndex, int chapterIndex) {
        int bookIndex1 = Integer.parseInt(ModuleBooks.get(BooksAvailable.elementAt(bookIndex)).toString());
        return Integer.parseInt(numberOfVerses[bookIndex1].elementAt(chapterIndex).toString());
    }

    public String getReferenceString(int bookIndex, int chapterIndex, int verseIndex) {
        return chapterIndex + this.getStartChapter(bookIndex) + ":" + (verseIndex + 1);
    }

    static {
        numberImageFonts = 0;
        ModuleChange = false;
        FontIndependent = false;
        IndexBooksAvailable = new Vector();
        BooksAvailable = new Vector();
        ChapterStart = new Vector();
        ChapterEnd = new Vector();
        TouchScreen = false;
    }
}

