/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class BookmarkEntry {
    int bookIndex;
    int chapterIndex;
    int verseIndex;
    String excerpt;

    public BookmarkEntry(int bookIndex, int chapterIndex, int verseIndex, String excerpt) {
        this.bookIndex = bookIndex;
        this.chapterIndex = chapterIndex;
        this.verseIndex = verseIndex;
        this.excerpt = excerpt;
    }

    public BookmarkEntry(DataInputStream input) throws IOException {
        this.bookIndex = input.read();
        this.chapterIndex = input.read();
        this.verseIndex = input.read();
        this.excerpt = input.readUTF();
    }

    public void write(DataOutputStream output) throws IOException {
        output.writeByte(this.bookIndex);
        output.writeByte(this.chapterIndex);
        output.writeByte(this.verseIndex);
        output.writeUTF(this.excerpt);
    }

    public int value() {
        return this.bookIndex * 1000000 + this.chapterIndex * 1000 + this.verseIndex;
    }
}

