/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

class BookmarksList
extends List
implements CommandListener {
    private BiblePhone biblePhone;
    private Command viewCommand = new Command(BiblePhone.getString("UI-View"), 8, 0);
    private Command backCommand = new Command(BiblePhone.getString("UI-Back"), 3, 0);
    private Command cancelCommand = new Command(BiblePhone.getString("UI-Cancel"), 3, 0);
    private Command deleteBookmarkCommand = new Command(BiblePhone.getString("UI-Delete-Bookmark"), 1, 0);
    private Command deleteCommand = new Command(BiblePhone.getString("UI-Delete"), 1, 0);
    private Alert deleteAlert;
    private int indexToDelete;

    public BookmarksList(BiblePhone biblePhone) {
        super(BiblePhone.getString("UI-Bookmarks"), 3);
        if (BiblePhone.USE_MIDP20) {
            this.setFitPolicy(1);
        }
        this.biblePhone = biblePhone;
        Enumeration e = biblePhone.bookmarks.elements();
        while (e.hasMoreElements()) {
            BookmarkEntry bookmark = (BookmarkEntry)e.nextElement();
            this.append(biblePhone.getBookName(bookmark.bookIndex) + " " + biblePhone.getReferenceString(bookmark.bookIndex, bookmark.chapterIndex, bookmark.verseIndex) + " \"" + bookmark.excerpt + "\"", null);
        }
        this.setSelectCommand(this.viewCommand);
        this.addCommand(this.deleteBookmarkCommand);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable display) {
        if (display == this) {
            if (command == this.viewCommand) {
                int selectedIndex = this.getSelectedIndex();
                if (selectedIndex != -1) {
                    BookmarkEntry bookmark = (BookmarkEntry)this.biblePhone.bookmarks.elementAt(selectedIndex);
                    this.biblePhone.currentBookIndex = bookmark.bookIndex & 0xFF;
                    this.biblePhone.currentChapterIndex = bookmark.chapterIndex & 0xFF;
                    this.biblePhone.currentVerseIndex = bookmark.verseIndex & 0xFF;
                    this.biblePhone.bibleCanvas.enterLoadingMode();
                    this.biblePhone.display.setCurrent((Displayable)this.biblePhone.bibleCanvas);
                    this.biblePhone.loadCurrentChapter();
                    this.biblePhone.bibleCanvas.update();
                }
            } else if (command == this.deleteBookmarkCommand) {
                this.indexToDelete = this.getSelectedIndex();
                if (this.indexToDelete != -1) {
                    this.deleteAlert = new Alert(BiblePhone.getString("UI-Delete-Bookmark"), BiblePhone.getString("UI-Delete-Bookmark-Alert"), null, AlertType.CONFIRMATION);
                    this.deleteAlert.addCommand(this.cancelCommand);
                    this.deleteAlert.addCommand(this.deleteCommand);
                    this.deleteAlert.setCommandListener((CommandListener)this);
                    this.biblePhone.display.setCurrent(this.deleteAlert, (Displayable)this);
                }
            } else {
                switch (command.getCommandType()) {
                    case 2: 
                    case 3: 
                    case 4: {
                        this.biblePhone.bibleCanvas.enterLoadingMode();
                        this.biblePhone.display.setCurrent((Displayable)this.biblePhone.bibleCanvas);
                        this.biblePhone.bibleCanvas.repaint();
                        this.biblePhone.loadCurrentChapter();
                        this.biblePhone.showMainScreen();
                    }
                }
            }
        } else if (display == this.deleteAlert) {
            if (command == this.deleteCommand) {
                this.delete(this.indexToDelete);
                this.biblePhone.bookmarks.removeElementAt(this.indexToDelete);
            }
            this.biblePhone.display.setCurrent((Displayable)this);
        }
    }
}

