/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

class HistoryList
extends List
implements CommandListener {
    private BiblePhone biblePhone;

    public HistoryList(BiblePhone biblePhone) {
        super(BiblePhone.getString("UI-History"), 3);
        if (BiblePhone.USE_MIDP20) {
            this.setFitPolicy(1);
        }
        this.biblePhone = biblePhone;
        int i = biblePhone.historyStartIndex;
        do {
            if (biblePhone.historyExcerpts[i] != null && !biblePhone.historyExcerpts[i].equals("")) {
                int bookIndex = biblePhone.historyVerseIndices[i * 3] & 0xFF;
                int chapterIndex = biblePhone.historyVerseIndices[i * 3 + 1] & 0xFF;
                int verseIndex = biblePhone.historyVerseIndices[i * 3 + 2] & 0xFF;
                this.append(biblePhone.getBookName(bookIndex) + " " + biblePhone.getReferenceString(bookIndex, chapterIndex, verseIndex) + " \"" + biblePhone.historyExcerpts[i] + "\"", null);
            }
            if (++i < 20) continue;
            i = 0;
        } while (i != biblePhone.historyStartIndex);
        this.addCommand(new Command(BiblePhone.getString("UI-Back"), 3, 0));
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable display) {
        if (command == List.SELECT_COMMAND) {
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex != -1) {
                if ((selectedIndex += this.biblePhone.historyStartIndex) >= 20) {
                    selectedIndex -= 20;
                }
                this.biblePhone.currentBookIndex = this.biblePhone.historyVerseIndices[selectedIndex * 3] & 0xFF;
                this.biblePhone.currentChapterIndex = this.biblePhone.historyVerseIndices[selectedIndex * 3 + 1] & 0xFF;
                this.biblePhone.currentVerseIndex = this.biblePhone.historyVerseIndices[selectedIndex * 3 + 2] & 0xFF;
                this.biblePhone.bibleCanvas.enterLoadingMode();
                this.biblePhone.display.setCurrent((Displayable)this.biblePhone.bibleCanvas);
                this.biblePhone.loadCurrentChapter();
                this.biblePhone.bibleCanvas.update();
            }
        } else {
            switch (command.getCommandType()) {
                case 3: 
                case 4: {
                    this.biblePhone.bibleCanvas.enterLoadingMode();
                    this.biblePhone.display.setCurrent((Displayable)this.biblePhone.bibleCanvas);
                    this.biblePhone.bibleCanvas.repaint();
                    this.biblePhone.loadCurrentChapter();
                    this.biblePhone.showMainScreen();
                }
            }
        }
    }
}

