/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;

class PrefsForm
extends Form
implements CommandListener,
ItemCommandListener {
    private BiblePhone biblePhone;
    private ChoiceGroup fontSizeChoice;
    private ChoiceGroup fontStyleChoice;
    private ChoiceGroup fullScreenChoice;
    private ChoiceGroup themeChoice;
    private ChoiceGroup reverseColoursChoice;
    private ChoiceGroup reverseCharactersChoice;
    private ColourItem[] themeItems = new ColourItem[]{new ColourItem(0, BiblePhone.getString("UI-Theme-Paper"), BiblePhone.THEME_TEXT_COLOUR[0], BiblePhone.THEME_BACK_COLOUR[0]), new ColourItem(1, BiblePhone.getString("UI-Theme-Computer"), BiblePhone.THEME_TEXT_COLOUR[1], BiblePhone.THEME_BACK_COLOUR[1]), new ColourItem(2, BiblePhone.getString("UI-Theme-Floral"), BiblePhone.THEME_TEXT_COLOUR[2], BiblePhone.THEME_BACK_COLOUR[2]), new ColourItem(3, BiblePhone.getString("UI-Theme-Natural"), BiblePhone.THEME_TEXT_COLOUR[3], BiblePhone.THEME_BACK_COLOUR[3]), new ColourItem(4, BiblePhone.getString("UI-Theme-Blue"), BiblePhone.THEME_TEXT_COLOUR[4], BiblePhone.THEME_BACK_COLOUR[4]), new ColourItem(5, BiblePhone.getString("UI-Theme-Sunshine"), BiblePhone.THEME_TEXT_COLOUR[5], BiblePhone.THEME_BACK_COLOUR[5])};
    private ColourItem themeItem;
    private Command saveCommand = new Command(BiblePhone.getString("UI-Save"), 4, 0);
    private Command cancelCommand = new Command(BiblePhone.getString("UI-Cancel"), 3, 0);
    private Command selectCommand = new Command(BiblePhone.getString("UI-Select"), 8, 0);
    Form themeForm;

    public PrefsForm(BiblePhone biblePhone) {
        super(BiblePhone.getString("UI-Preferences"));
        this.biblePhone = biblePhone;
        this.append((Item)new StringItem(BiblePhone.getString("UI-Theme") + ":", null));
        ColourItem storedThemeItem = this.themeItems[biblePhone.theme];
        this.themeItem = new ColourItem(storedThemeItem.id, storedThemeItem.text, storedThemeItem.textColour, storedThemeItem.backColour);
        this.themeItem.addCommand(new Command(BiblePhone.getString("UI-Change"), 8, 0));
        this.themeItem.setItemCommandListener(this);
        this.append((Item)this.themeItem);
        for (int i = 0; i < this.themeItems.length; ++i) {
            this.themeItems[i].addCommand(this.selectCommand);
            this.themeItems[i].setItemCommandListener(this);
        }
        this.fontSizeChoice = new ChoiceGroup(BiblePhone.getString("UI-Font-Size") + ":", 1, new String[]{BiblePhone.getString("UI-Small"), BiblePhone.getString("UI-Medium"), BiblePhone.getString("UI-Large")}, null);
        this.fontSizeChoice.setFont(0, Font.getFont((int)0, (int)0, (int)8));
        this.fontSizeChoice.setFont(1, Font.getFont((int)0, (int)0, (int)0));
        this.fontSizeChoice.setFont(2, Font.getFont((int)0, (int)0, (int)16));
        this.fontSizeChoice.setSelectedIndex(biblePhone.fontSize, true);
        this.append((Item)this.fontSizeChoice);
        this.fontStyleChoice = new ChoiceGroup(BiblePhone.getString("UI-Font-Style") + ":", 1, new String[]{BiblePhone.getString("UI-Plain"), BiblePhone.getString("UI-Bold")}, null);
        this.fontStyleChoice.setFont(0, Font.getFont((int)0, (int)0, (int)0));
        this.fontStyleChoice.setFont(1, Font.getFont((int)0, (int)1, (int)0));
        this.fontStyleChoice.setSelectedIndex(biblePhone.fontStyle, true);
        this.append((Item)this.fontStyleChoice);
        if (BiblePhone.USE_MIDP20) {
            this.fullScreenChoice = new ChoiceGroup(BiblePhone.getString("UI-Full-Screen") + ":", 1, new String[]{BiblePhone.getString("UI-On"), BiblePhone.getString("UI-Off")}, null);
            this.fullScreenChoice.setSelectedIndex(biblePhone.fullScreen ? 0 : 1, true);
            this.append((Item)this.fullScreenChoice);
        }
        this.reverseColoursChoice = new ChoiceGroup(BiblePhone.getString("UI-Reverse-Colours") + ":", 1, new String[]{BiblePhone.getString("UI-On"), BiblePhone.getString("UI-Off")}, null);
        this.reverseColoursChoice.setSelectedIndex(biblePhone.reverseColours ? 0 : 1, true);
        this.append((Item)this.reverseColoursChoice);
        this.reverseCharactersChoice = new ChoiceGroup(BiblePhone.getString("UI-Reverse-Characters") + ":", 1, new String[]{BiblePhone.getString("UI-On"), BiblePhone.getString("UI-Off")}, null);
        BibleCanvas cfr_ignored_0 = biblePhone.bibleCanvas;
        this.reverseCharactersChoice.setSelectedIndex(BibleCanvas.reverseCharacters ? 0 : 1, true);
        this.append((Item)this.reverseCharactersChoice);
        this.addCommand(this.saveCommand);
        this.addCommand(this.cancelCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable display) {
        if (display == this) {
            switch (command.getCommandType()) {
                case 4: {
                    this.biblePhone.fontSize = this.fontSizeChoice.getSelectedIndex();
                    this.biblePhone.fontStyle = this.fontStyleChoice.getSelectedIndex();
                    if (BiblePhone.USE_MIDP20) {
                        this.biblePhone.fullScreen = this.fullScreenChoice.getSelectedIndex() == 0;
                    }
                    this.biblePhone.theme = this.themeItem.id;
                    this.biblePhone.reverseColours = this.reverseColoursChoice.getSelectedIndex() == 0;
                    BibleCanvas cfr_ignored_0 = this.biblePhone.bibleCanvas;
                    BibleCanvas.reverseCharacters = this.reverseCharactersChoice.getSelectedIndex() == 0;
                    this.biblePhone.showMainScreen();
                    break;
                }
                case 2: 
                case 3: {
                    this.biblePhone.showMainScreen();
                }
            }
        } else if (display == this.themeForm) {
            switch (command.getCommandType()) {
                case 2: 
                case 3: {
                    this.biblePhone.display.setCurrent((Displayable)this);
                }
            }
        }
    }

    public void commandAction(Command command, Item item) {
        if (item == this.themeItem) {
            this.displayThemeForm();
        } else if (item instanceof ColourItem) {
            ColourItem newThemeItem = (ColourItem)item;
            this.themeItem.id = newThemeItem.id;
            this.themeItem.setText(newThemeItem.text);
            this.themeItem.textColour = newThemeItem.textColour;
            this.themeItem.backColour = newThemeItem.backColour;
            this.themeItem.notifyStateChanged();
            this.biblePhone.display.setCurrent((Displayable)this);
        }
    }

    private void displayThemeForm() {
        if (this.themeForm == null) {
            this.themeForm = new Form(BiblePhone.getString("UI-Themes"), (Item[])this.themeItems);
            this.themeForm.addCommand(this.cancelCommand);
            this.themeForm.setCommandListener((CommandListener)this);
        }
        this.biblePhone.display.setCurrent((Displayable)this.themeForm);
    }
}

