/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

class SearchForm
extends Form
implements CommandListener {
    private BiblePhone biblePhone;
    private TextField searchTextField;
    private ChoiceGroup bookChoiceGroup;
    private ChoiceGroup fromBookChoiceGroup;
    private ChoiceGroup toBookChoiceGroup;
    private ChoiceGroup caseInsensitiveSearchingChoiceGroup;
    private Command searchCommand = new Command(BiblePhone.getString("UI-Search"), 4, 0);
    private Command cancelCommand = new Command(BiblePhone.getString("UI-Cancel"), 3, 0);
    private String[] bookNames;

    public SearchForm(BiblePhone biblePhone) {
        super("Search");
        this.biblePhone = biblePhone;
        this.fromBookChoiceGroup = new ChoiceGroup(BiblePhone.getString("UI-From-Book") + ":", 4);
        this.toBookChoiceGroup = new ChoiceGroup(BiblePhone.getString("UI-To-Book") + ":", 4);
        this.caseInsensitiveSearchingChoiceGroup = new ChoiceGroup(BiblePhone.getString("UI-Case-Insensitive-Searching") + ":", 1, new String[]{BiblePhone.getString("UI-On"), BiblePhone.getString("UI-Off")}, null);
        String[] bookNames = biblePhone.getBookNames();
        for (int i = 0; i < bookNames.length; ++i) {
            this.fromBookChoiceGroup.append(bookNames[i], null);
            this.toBookChoiceGroup.append(bookNames[i], null);
        }
        if (biblePhone.lastFromBook == -1) {
            biblePhone.lastFromBook = 0;
            biblePhone.lastToBook = bookNames.length - 1;
        }
        this.fromBookChoiceGroup.setSelectedIndex(biblePhone.lastFromBook, true);
        this.toBookChoiceGroup.setSelectedIndex(biblePhone.lastToBook, true);
        this.caseInsensitiveSearchingChoiceGroup.setSelectedIndex(biblePhone.caseInsensitiveSearching ? 0 : 1, true);
        this.searchTextField = new TextField(BiblePhone.getString("UI-Search-Text") + ":", biblePhone.lastSearchString, 30, 0);
        this.append((Item)this.searchTextField);
        this.append((Item)this.fromBookChoiceGroup);
        this.append((Item)this.toBookChoiceGroup);
        this.append((Item)this.caseInsensitiveSearchingChoiceGroup);
        this.addCommand(this.searchCommand);
        this.addCommand(this.cancelCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable display) {
        switch (command.getCommandType()) {
            case 4: {
                if (this.searchTextField.getString().equals("")) break;
                this.biblePhone.lastSearchString = this.searchTextField.getString();
                this.biblePhone.lastFromBook = this.fromBookChoiceGroup.getSelectedIndex();
                this.biblePhone.lastToBook = this.toBookChoiceGroup.getSelectedIndex();
                this.biblePhone.display.setCurrent((Displayable)new SearchingCanvas(this.biblePhone, this.biblePhone.lastFromBook, this.biblePhone.lastToBook, this.biblePhone.lastSearchString));
                this.biblePhone.caseInsensitiveSearching = this.caseInsensitiveSearchingChoiceGroup.getSelectedIndex() == 0;
                break;
            }
            case 2: 
            case 3: {
                this.biblePhone.showMainScreen();
            }
        }
    }
}

