/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

class SearchResultsList
extends List
implements CommandListener {
    private BiblePhone biblePhone;
    private Vector searchResults;

    public SearchResultsList(BiblePhone biblePhone, Vector searchResults) {
        super(BiblePhone.getString("UI-Results"), 3);
        if (BiblePhone.USE_MIDP20) {
            this.setFitPolicy(1);
        }
        this.biblePhone = biblePhone;
        this.searchResults = searchResults;
        Enumeration e = searchResults.elements();
        while (e.hasMoreElements()) {
            Object[] entry = (Object[])e.nextElement();
            int index = (Integer)entry[0];
            int bookIndex = index >> 16 & 0xFF;
            int chapterIndex = index >> 8 & 0xFF;
            int verseIndex = index & 0xFF;
            this.append(biblePhone.getBookName(bookIndex) + " " + biblePhone.getReferenceString(bookIndex, chapterIndex, verseIndex) + " \"" + (String)entry[1] + "\"", null);
        }
        this.addCommand(new Command(BiblePhone.getString("UI-Cancel"), 3, 0));
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable display) {
        if (command == List.SELECT_COMMAND) {
            int selectedIndex = this.getSelectedIndex();
            int index = (Integer)((Object[])this.searchResults.elementAt(selectedIndex))[0];
            this.biblePhone.currentBookIndex = index >> 16 & 0xFF;
            this.biblePhone.currentChapterIndex = index >> 8 & 0xFF;
            this.biblePhone.currentVerseIndex = index & 0xFF;
            this.biblePhone.bibleCanvas.enterLoadingMode();
            this.biblePhone.display.setCurrent((Displayable)this.biblePhone.bibleCanvas);
            this.biblePhone.loadCurrentChapter();
            this.biblePhone.bibleCanvas.update();
        } else {
            switch (command.getCommandType()) {
                case 3: 
                case 4: {
                    this.biblePhone.bibleCanvas.enterLoadingMode();
                    this.biblePhone.display.setCurrent((Displayable)this.biblePhone.bibleCanvas);
                    this.biblePhone.bibleCanvas.repaint();
                    this.biblePhone.loadCurrentChapter();
                    this.biblePhone.showMainScreen();
                }
            }
        }
    }
}

