/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class SearchingCanvas
extends Canvas
implements CommandListener,
Runnable {
    private static int EXTRA_DISPLAY_CHARS = 10;
    private static int MAX_RESULTS = 200;
    private BiblePhone biblePhone;
    private boolean stop;
    private int currentChapter;
    private int currentBook;
    private int searchFromBookIndex;
    private int searchToBookIndex;
    private String searchString;
    private byte[] byteArray;
    int bookIndex;

    public SearchingCanvas(BiblePhone biblePhone, int fromBookIndex, int toBookIndex, String searchString) {
        this.biblePhone = biblePhone;
        biblePhone.searchResults.removeAllElements();
        this.searchFromBookIndex = fromBookIndex;
        this.searchToBookIndex = toBookIndex;
        this.searchString = searchString;
        this.addCommand(new Command(BiblePhone.getString("UI-Stop"), 6, 0));
        this.setCommandListener(this);
        this.currentBook = fromBookIndex;
        this.currentChapter = 0;
        new Thread(this).start();
    }

    public void commandAction(Command command, Displayable display) {
        switch (command.getCommandType()) {
            case 6: {
                this.stop = true;
                this.biblePhone.display.setCurrent((Displayable)new SearchResultsList(this.biblePhone, this.biblePhone.searchResults));
            }
        }
    }

    public void run() {
        int index1 = 0;
        int indexNext1 = -1;
        boolean sgn = false;
        int sg = 0;
        String valoare = "";
        EXTRA_DISPLAY_CHARS = Integer.parseInt(BiblePhone.getStringConfig("dimensionSearchedString", BiblePhone.ConfigIni));
        MAX_RESULTS = Integer.parseInt(BiblePhone.getStringConfig("maximumSearchedResults", BiblePhone.ConfigIni));
        char[] searchData = this.searchString.toCharArray();
        int endBook = this.searchToBookIndex;
        int numberOfBooks = this.biblePhone.getNumberOfBooks();
        int numberFound = 0;
        this.bookIndex = this.currentBook;
        try {
            byte[] searchArray = this.searchString.getBytes("UTF-8");
            byte[] searchArrayLowerCase = this.searchString.toLowerCase().getBytes("UTF-8");
            byte[] searchArrayUpperCase = this.searchString.toUpperCase().getBytes("UTF-8");
            if (searchArray.length == 0) {
                return;
            }
            while (this.bookIndex != endBook + 1 && !this.stop && numberFound < MAX_RESULTS) {
                if (this.bookIndex >= numberOfBooks) {
                    this.bookIndex = 0;
                }
                this.currentBook = this.bookIndex;
                this.currentChapter = 0;
                this.repaint();
                int endChapter = this.biblePhone.getNumberOfChapters(this.currentBook) - 1;
                int bookIndex1 = Integer.parseInt(BiblePhone.ModuleBooks.get(BiblePhone.BooksAvailable.elementAt(this.currentBook)).toString());
                while (this.currentChapter <= endChapter && !this.stop && numberFound < MAX_RESULTS) {
                    long start1 = 0L;
                    long end1 = 0L;
                    int currentChapter1 = this.currentChapter + Integer.parseInt(BiblePhone.ChapterStart.elementAt(this.currentBook).toString()) - 1;
                    start1 = currentChapter1 == 0 ? 0L : (long)Integer.parseInt(BiblePhone.indexOfChapters[bookIndex1].elementAt(currentChapter1 - 1).toString());
                    end1 = Integer.parseInt(BiblePhone.indexOfChapters[bookIndex1].elementAt(currentChapter1).toString());
                    int length1 = (int)(end1 - start1);
                    DataInputStream inputSearch = new DataInputStream(this.biblePhone.getClass().getResourceAsStream("bibles/" + BiblePhone.getStringConfig("bible" + BiblePhone.BasicModuleIndex, BiblePhone.ConfigIni) + "/" + BiblePhone.BooksAvailable.elementAt(this.bookIndex) + "/" + currentChapter1));
                    this.byteArray = null;
                    this.byteArray = new byte[length1];
                    inputSearch.read(this.byteArray, 0, length1);
                    inputSearch.close();
                    int numberOfVerses = Integer.parseInt(BiblePhone.numberOfVerses[bookIndex1].elementAt(currentChapter1).toString());
                    index1 = 0;
                    indexNext1 = -1;
                    for (int currentVerse = 0; currentVerse < numberOfVerses && !this.stop && numberFound < MAX_RESULTS; ++currentVerse) {
                        int afterIndex;
                        int i;
                        sg = 0;
                        sgn = false;
                        boolean found = false;
                        int indexInitial = 0;
                        if (this.biblePhone.caseInsensitiveSearching) {
                            for (i = index1; i < length1; ++i) {
                                if (!sgn && this.byteArray[i] == 32) {
                                    sgn = true;
                                    if (indexInitial == 0) {
                                        indexInitial = i;
                                    }
                                }
                                if (this.byteArray[i] == 13) {
                                    index1 = i + 1;
                                    break;
                                }
                                if (sgn) {
                                    sg = this.byteArray[i] == searchArray[sg] || this.byteArray[i] == searchArrayLowerCase[sg] || this.byteArray[i] == searchArrayUpperCase[sg] ? ++sg : (this.byteArray[i] == searchArray[0] || this.byteArray[i] == searchArrayLowerCase[0] || this.byteArray[i] == searchArrayUpperCase[0] ? 1 : 0);
                                }
                                if (sg != searchArray.length) continue;
                                found = true;
                                sg = 0;
                                sgn = false;
                            }
                        } else {
                            for (i = index1; i < length1; ++i) {
                                if (!sgn && this.byteArray[i] == 32) {
                                    sgn = true;
                                    if (indexInitial == 0) {
                                        indexInitial = i;
                                    }
                                }
                                if (this.byteArray[i] == 13) {
                                    index1 = i + 1;
                                    break;
                                }
                                if (sgn) {
                                    sg = this.byteArray[i] == searchArray[sg] ? ++sg : (this.byteArray[i] == searchArray[0] ? 1 : 0);
                                }
                                if (sg != searchArray.length) continue;
                                found = true;
                                sg = 0;
                                sgn = false;
                            }
                        }
                        if (!found) continue;
                        valoare = new String("get");
                        String verset1 = new String(this.byteArray, indexInitial + 1, index1 - indexInitial - 1, "UTF-8");
                        String verset = this.biblePhone.replace(this.biblePhone.replace(this.biblePhone.replace(this.biblePhone.replace(this.biblePhone.replace(verset1, "~", ""), "    ", " "), "   ", " "), "  ", " "), "^", "");
                        char[] verseData = verset.toCharArray();
                        valoare = new String("utf");
                        int end = verseData.length;
                        int index = verset.indexOf(this.searchString);
                        valoare = new String("search");
                        int extraCharsBefore = index - EXTRA_DISPLAY_CHARS;
                        int extraCharsAfter = end - (index + searchData.length + EXTRA_DISPLAY_CHARS);
                        int beforeIndex = extraCharsBefore >= 0 ? index - EXTRA_DISPLAY_CHARS : 0;
                        int n = afterIndex = extraCharsAfter >= 0 ? index + searchData.length + EXTRA_DISPLAY_CHARS : end;
                        if (extraCharsAfter < 0 && beforeIndex > 0) {
                            int n2 = beforeIndex = (beforeIndex += extraCharsAfter) < 0 ? 0 : beforeIndex;
                        }
                        if (extraCharsBefore < 0 && afterIndex < end) {
                            int n3 = afterIndex = (afterIndex -= extraCharsBefore) > end ? end : afterIndex;
                        }
                        if (SearchingCanvas.isLetter(verseData[beforeIndex])) {
                            while (beforeIndex > 0 && SearchingCanvas.isLetter(verseData[beforeIndex - 1])) {
                                --beforeIndex;
                            }
                        }
                        if (SearchingCanvas.isLetter(verseData[afterIndex - 1])) {
                            while (afterIndex < end && SearchingCanvas.isLetter(verseData[afterIndex])) {
                                ++afterIndex;
                            }
                        }
                        this.biblePhone.searchResults.addElement(new Object[]{new Integer(this.currentBook << 16 | this.currentChapter << 8 | currentVerse), new String(verseData, beforeIndex, afterIndex - beforeIndex).replace('\u0001', ' ')});
                        ++numberFound;
                    }
                    this.repaint();
                    this.serviceRepaints();
                    ++this.currentChapter;
                }
                ++this.bookIndex;
            }
            if (this.biblePhone.searchResults.size() > 0) {
                this.biblePhone.display.setCurrent((Displayable)new SearchResultsList(this.biblePhone, this.biblePhone.searchResults));
            } else {
                this.biblePhone.bibleCanvas.enterLoadingMode();
                this.biblePhone.display.setCurrent((Displayable)this.biblePhone.bibleCanvas);
                this.biblePhone.bibleCanvas.repaint();
                this.biblePhone.loadCurrentChapter();
                this.biblePhone.showMainScreen();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static final boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static final int find(char[] data, int offset, int end, char[] searchData) {
        int result = -1;
        int searchStringLength = searchData.length;
        int totalEnd = end - searchStringLength;
        int lowerDiff = 32;
        for (int i = offset; i < totalEnd && result == -1; ++i) {
            char currentChar = data[i];
            if (currentChar >= 'A' && currentChar <= 'Z') {
                currentChar = (char)(currentChar + lowerDiff);
            }
            if (currentChar != searchData[0]) continue;
            boolean matches = true;
            for (int j = 1; j < searchStringLength && matches; ++j) {
                currentChar = data[i + j];
                if (currentChar >= 'A' && currentChar <= 'Z') {
                    currentChar = (char)(currentChar + lowerDiff);
                }
                if (currentChar == searchData[j]) continue;
                matches = false;
            }
            if (!matches) continue;
            result = i;
        }
        return result;
    }

    public void paint(Graphics g) {
        int width = this.getWidth();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, width, this.getHeight());
        Font font = Font.getFont((int)0, (int)1, (int)0);
        g.setFont(font);
        g.setColor(0);
        int halfWidth = width >> 1;
        g.drawString(BiblePhone.getString("UI-Searching") + ":", halfWidth, 20, 17);
        String bookName = this.biblePhone.getBookName(this.bookIndex);
        String chapterString = " " + (this.currentChapter + this.biblePhone.getStartChapter(this.bookIndex));
        int bookNameWidth = font.stringWidth(bookName);
        int totalWidth = font.stringWidth(bookName + chapterString);
        int startX = width - totalWidth >> 1;
        BibleCanvas.drawString(g, bookName + ":" + chapterString, startX, 40, 20);
        g.drawString(BiblePhone.getString("UI-Found") + " " + this.biblePhone.searchResults.size(), halfWidth, 60, 17);
        g.drawString(BiblePhone.getString("UI-Please-Wait") + "...", halfWidth, 80, 17);
    }
}

